/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.MindMapMessages;

public class DeleteMarkerCommand
extends SourceCommand {
    private String markerId;

    public DeleteMarkerCommand(ITopic topic, String markerId) {
        super((Object)topic);
        Assert.isNotNull((Object)markerId);
        this.markerId = markerId;
        this.setLabel(MindMapMessages.DeleteMarker_label);
    }

    public DeleteMarkerCommand(IMarkerRef markerRef) {
        Assert.isNotNull((Object)markerRef);
        ITopic topic = markerRef.getParent();
        Assert.isNotNull((Object)topic);
        String markerId = markerRef.getMarkerId();
        Assert.isNotNull((Object)markerId);
        this.setSource(topic);
        this.markerId = markerId;
        this.setLabel(MindMapMessages.DeleteMarker_label);
    }

    public int getType() {
        return 2;
    }

    public void redo() {
        ((ITopic)this.getSource()).removeMarker(this.markerId);
        super.redo();
    }

    public void undo() {
        ((ITopic)this.getSource()).addMarker(this.markerId);
        super.undo();
    }
}

