/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.workbooks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.search.SearchPlugin;
import org.xmind.ui.internal.search.workbooks.ISearchResultItem;
import org.xmind.ui.internal.search.workbooks.MindMapSearchEngine;
import org.xmind.ui.internal.search.workbooks.SearchMessages;
import org.xmind.ui.resources.ColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDialog
extends Dialog
implements Listener,
IPartListener {
    private static final String KEY_PARAMETER = "SEARCH_PARAMETER";
    private static final String KEY_HISTORY = "SEARCH_HISTORY";
    private Combo searchInput;
    private Button searchButton;
    private TreeViewer treeViewer;
    private IDialogSettings dialogSettings;
    private int parameter = 0;
    private List<String> searchHistory;
    private Control focused;
    private ResourceManager resources;

    public SearchDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3296);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                super.shellActivated(e);
                SearchDialog.this.doSetFocus();
            }
        });
        newShell.setText(SearchMessages.SearchDialog_Title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createDescriptionArea(composite);
        this.createSeparator(composite);
        Composite content = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 14;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(1808));
        this.createInputArea(content);
        this.createOptionsArea(content);
        this.createResultArea(content);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.addPartListener((IPartListener)this);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 13;
        layout.marginHeight = 23;
        layout.horizontalSpacing = 18;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 14;
        gridLayout.marginHeight = 18;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label discriptionLabel = new Label(composite, 64);
        GridData discriptionLabelData = new GridData(4, 0x1000000, true, true);
        discriptionLabel.setLayoutData((Object)discriptionLabelData);
        discriptionLabel.setAlignment(16384);
        discriptionLabel.setText(SearchMessages.SearchDialog_Message);
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cfcfcf")));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 1;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
    }

    private void createInputArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 10;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setBackground(parent.getBackground());
        this.createInputBox(container);
        this.createSearchButton(container);
    }

    private void createInputBox(Composite parent) {
        this.searchInput = new Combo(parent, 2052);
        this.searchInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (this.searchHistory != null && this.searchHistory.size() > 0) {
            this.searchInput.setText(this.searchHistory.get(0));
        } else {
            this.searchInput.setText(SearchMessages.SearchSuggest_Text);
        }
        this.updateInputHistory();
        this.searchInput.addListener(24, (Listener)this);
        this.searchInput.addListener(14, (Listener)this);
        this.searchInput.addListener(15, (Listener)this);
    }

    private void updateInputHistory() {
        if (this.searchInput == null || this.searchInput.isDisposed() || this.searchHistory == null) {
            return;
        }
        String text = this.searchInput.getText();
        this.searchInput.setItems(this.searchHistory.toArray(new String[this.searchHistory.size()]));
        this.searchInput.setText(text);
    }

    private void createSearchButton(Composite parent) {
        this.searchButton = new Button(parent, 8);
        this.searchButton.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.searchButton.setText(SearchMessages.SearchButton_Text);
        this.searchButton.setEnabled(false);
        this.searchButton.addListener(13, (Listener)this);
        this.updateSearchButton();
    }

    private void updateSearchButton() {
        String content = this.searchInput.getText().trim();
        this.searchButton.setEnabled(!"".equals(content));
    }

    private void createOptionsArea(Composite parent) {
        final WidgetFactory factory = new WidgetFactory(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                factory.dispose();
            }
        });
        factory.setBackground(parent.getBackground());
        Section section = factory.createSection(parent, 98);
        section.setText(SearchMessages.SearchOptions_Text);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite content = factory.createComposite((Composite)section, 64);
        section.setClient((Control)content);
        GridLayout contentLayout = new GridLayout(1, false);
        contentLayout.marginWidth = 0;
        contentLayout.marginHeight = 0;
        contentLayout.marginBottom = 0;
        contentLayout.verticalSpacing = 5;
        contentLayout.horizontalSpacing = 0;
        content.setLayout((Layout)contentLayout);
        OptionButtonCreator creator = new OptionButtonCreator();
        Composite options1 = this.createOptionsLine(content, 2);
        creator.create(options1, 1, SearchMessages.SenesitiveButton_Text);
        creator.create(options1, 2, SearchMessages.OnlyActiveEditorButton_Text);
        Composite options2 = this.createOptionsLine(content, 5);
        creator.create(options2, 4, SearchMessages.TopicsButton_Text);
        creator.create(options2, 8, SearchMessages.BounariesButton_Text);
        creator.create(options2, 16, SearchMessages.RelationshipsButton_Text);
        creator.create(options2, 32, SearchMessages.LabelsButton_Text);
        creator.create(options2, 64, SearchMessages.NotesButton_Text);
    }

    private Composite createOptionsLine(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.spacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setBackground(parent.getBackground());
        return composite;
    }

    private void createResultArea(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2052);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.getControl().addListener(15, new Listener(){

            public void handleEvent(Event event) {
                SearchDialog.this.focused = SearchDialog.this.treeViewer.getControl();
            }
        });
        this.treeViewer.setAutoExpandLevel(4);
        this.treeViewer.setContentProvider((IContentProvider)new TreeViewerContentProvioder());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SearchResultLabelProvider(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"), parent.getDisplay().getSystemColor(29), parent.getDisplay().getSystemColor(15)));
        this.treeViewer.setInput(null);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClickListener());
    }

    private void loadSettings() {
        this.dialogSettings = SearchPlugin.getDefault().getDialogSettings(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings != null) {
            if (this.dialogSettings.get(KEY_PARAMETER) == null) {
                this.dialogSettings.put(KEY_PARAMETER, 4);
            }
            if (this.dialogSettings.get(KEY_HISTORY) == null) {
                this.dialogSettings.put(KEY_HISTORY, "");
            }
        }
        this.parameter = this.dialogSettings == null ? 4 : this.dialogSettings.getInt(KEY_PARAMETER);
        String history = this.dialogSettings == null ? "" : this.dialogSettings.get(KEY_HISTORY);
        this.searchHistory = new ArrayList<String>(Arrays.asList(history.split("\r|\n|\r\n")));
    }

    private void saveSettings() {
        this.saveParameter();
        this.saveHistory();
    }

    private void setParameter(boolean selected, int parameterId) {
        this.parameter = selected ? (this.parameter |= parameterId) : (this.parameter &= ~parameterId);
        this.saveParameter();
    }

    private void saveParameter() {
        if (this.dialogSettings != null) {
            this.dialogSettings.put(KEY_PARAMETER, this.parameter);
        }
    }

    private boolean isSelected(int parameterId) {
        return (this.parameter & parameterId) != 0;
    }

    protected void initializeBounds() {
        this.getShell().setBounds(300, 150, 516, 500);
        super.initializeBounds();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.close();
        }
    }

    public boolean close() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        this.saveSettings();
        this.dialogSettings = null;
        this.searchHistory = null;
        return super.close();
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        int type = event.type;
        if (widget == this.searchInput) {
            if (type == 24) {
                this.updateSearchButton();
            } else if (type == 14) {
                this.saveSearchInput();
                this.search();
            } else if (type == 15) {
                this.focused = this.searchInput;
            }
        } else if (widget == this.searchButton && type == 13) {
            this.saveSearchInput();
            this.search();
        }
    }

    private void saveSearchInput() {
        if (this.searchInput == null || this.searchInput.isDisposed()) {
            return;
        }
        String text = this.searchInput.getText();
        if (text == null || "".equals(text)) {
            return;
        }
        if (this.searchHistory == null) {
            this.searchHistory = new ArrayList<String>();
        }
        int i = 0;
        while (i < this.searchHistory.size()) {
            String item = this.searchHistory.get(i);
            if (text.equals(item)) {
                this.searchHistory.remove(i);
                continue;
            }
            ++i;
        }
        this.searchHistory.add(0, text);
        this.saveHistory();
        this.updateInputHistory();
    }

    private void search() {
        VerifyUI20141031.getUsageDataCollector().increase("SearchInWorkbooksCount");
        if (this.searchInput == null || this.searchInput.isDisposed()) {
            return;
        }
        String toFind = this.searchInput.getText().trim().replaceAll("\r|\n|\r\n", "");
        if ("".equals(toFind)) {
            this.treeViewer.setInput(null);
            return;
        }
        MindMapSearchEngine engine = new MindMapSearchEngine(toFind, this.getOpenedEditors());
        engine.setParameter(this.parameter);
        engine.search();
        this.treeViewer.setInput(engine.getResult());
    }

    private void saveHistory() {
        if (this.dialogSettings != null && this.searchHistory != null) {
            this.dialogSettings.put(KEY_HISTORY, SearchDialog.join(this.searchHistory.toArray(), "\n"));
        }
    }

    private static String join(Object[] array, String sep) {
        StringBuilder sb = new StringBuilder(array.length * 20);
        String s = null;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (s == null) {
                s = sep;
            } else {
                sb.append(s);
            }
            sb.append(o.toString());
            ++n2;
        }
        return sb.toString();
    }

    private Collection<IEditorPart> getOpenedEditors() {
        if ((this.parameter & 2) != 0) {
            return Collections.singleton(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
        }
        IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        ArrayList<IEditorPart> editors = new ArrayList<IEditorPart>();
        IEditorReference[] iEditorReferenceArray = editorRefs;
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editor = editorRef.getEditor(true);
            editors.add(editor);
            ++n2;
        }
        return editors;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.search();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void doSetFocus() {
        if (this.focused != null && !this.focused.isDisposed()) {
            this.focused.setFocus();
        } else if (this.searchInput != null && !this.searchInput.isDisposed()) {
            this.searchInput.setFocus();
        }
    }

    private static class Grayer
    extends StyledString.Styler {
        private Color color;

        public Grayer(Color color) {
            this.color = color;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = this.color;
        }
    }

    private static class Highlighter
    extends StyledString.Styler {
        private Font font;
        private Color background;

        public Highlighter(Font font, Color background) {
            this.font = font;
            this.background = background;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = this.font;
            textStyle.background = this.background;
        }
    }

    private class OptionButtonCreator {
        private Listener buttonListener = new Listener(){

            public void handleEvent(Event event) {
                boolean selected = ((Button)event.widget).getSelection();
                int parameterId = (Integer)event.widget.getData();
                SearchDialog.this.setParameter(selected, parameterId);
            }
        };

        private Button create(Composite parent, int parameterId, String text) {
            Button button = new Button(parent, 32);
            button.setBackground(parent.getBackground());
            button.setSelection(SearchDialog.this.isSelected(parameterId));
            button.setText(text);
            button.setData((Object)parameterId);
            button.addListener(13, this.buttonListener);
            return button;
        }
    }

    private class SearchResultLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        private Map<Object, Image> images;

        public SearchResultLabelProvider(Font highlightFont, Color highlightBackground, Color grayColor) {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledSearchResultLabelProvider(highlightFont, highlightBackground, grayColor), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
            this.images = new HashMap<Object, Image>();
        }

        public String getText(Object element) {
            return element == null ? "" : element.toString();
        }

        public void dispose() {
            if (this.images != null) {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
                this.images.clear();
                this.images = null;
            }
            super.dispose();
        }
    }

    private class StyledSearchResultLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private StyledString.Styler highlighter;
        private StyledString.Styler grayer;

        public StyledSearchResultLabelProvider(Font highlightFont, Color highlightBackground, Color grayColor) {
            this.highlighter = new Highlighter(highlightFont, highlightBackground);
            this.grayer = new Grayer(grayColor);
        }

        private StyledString join(StyledString last, StyledString current) {
            if (last != null) {
                last.append(current);
                return last;
            }
            return current;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof ISearchResultItem) {
                ISearchResultItem item = (ISearchResultItem)element;
                String title = item.getTitle();
                String description = item.getDescription();
                StyledString str = null;
                if (title != null) {
                    int[] highlights = item.getHighlights();
                    if (highlights != null) {
                        int start = 0;
                        int i = 0;
                        while (i < highlights.length - 1) {
                            if (highlights[i] > start) {
                                str = this.join(str, new StyledString(title.substring(start, highlights[i])));
                            }
                            str = this.join(str, new StyledString(title.substring(highlights[i], highlights[i] + highlights[i + 1]), this.highlighter));
                            start = highlights[i] + highlights[i + 1];
                            i += 2;
                        }
                        if (start < title.length()) {
                            str = this.join(str, new StyledString(title.substring(start)));
                        }
                    } else {
                        str = this.join(str, new StyledString(title, this.grayer));
                    }
                    if (description != null) {
                        str = this.join(str, new StyledString(" ", this.grayer));
                    }
                }
                if (description != null) {
                    str = this.join(str, new StyledString(description, this.grayer));
                }
                if (str != null) {
                    return str;
                }
            }
            return new StyledString(super.getText(element));
        }
    }

    private class TreeDoubleClickListener
    implements IDoubleClickListener {
        private TreeDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            boolean stillValid;
            IStructuredSelection ss;
            Object element;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ISearchResultItem && !(stillValid = ((ISearchResultItem)element).reveal())) {
                SearchDialog.this.treeViewer.update(element, null);
            }
        }
    }

    private class TreeViewerContentProvioder
    implements ITreeContentProvider {
        private TreeViewerContentProvioder() {
        }

        public Object[] getChildren(Object element) {
            return ((ISearchResultItem)element).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((ISearchResultItem)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return !((ISearchResultItem)element).getChildren().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

