/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.core.ISheet;
import org.xmind.gef.IViewer;
import org.xmind.ui.internal.TopicContextService;
import org.xmind.ui.internal.presentation.AbstractPresentationWindows;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.util.MindMapUtils;

public class PresentationTopicContextService
extends TopicContextService
implements ISelectionProvider {
    private AbstractPresentationWindows window;

    public PresentationTopicContextService(IViewer viewer, AbstractPresentationWindows window) {
        super(viewer);
        this.window = window;
    }

    public Object getAdapter(Class adapter) {
        if (this.window != null && adapter == ISelectionProvider.class) {
            return this;
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        IPresentationPage page;
        if (this.window != null && (page = this.window.getCurrentPage()) != null) {
            return page.getViewer().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
        ISheet sheet;
        if (this.window != null && (sheet = this.findSheet(selection)) != null) {
            int i = 0;
            while (i < this.window.getPageCount()) {
                IPresentationPage page = this.window.getPage(i);
                if (page != null && sheet.equals(page.getInput().getSheet())) {
                    this.window.setCurrentPage(i);
                    if (this.window.getCurrentPage() == page) {
                        page.getViewer().setSelection(selection, true);
                    }
                }
                ++i;
            }
        }
    }

    private ISheet findSheet(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ISheet sheet = MindMapUtils.findSheet((Object)o);
                if (sheet != null) {
                    return sheet;
                }
                ++n2;
            }
        }
        return null;
    }

    public void dispose() {
        this.window = null;
        super.dispose();
    }
}

