/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.index.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.index.resource.AbstractIndexResource;
import org.xmind.ui.internal.index.resource.ILabelResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelResourceForWorkbook
extends AbstractIndexResource
implements ILabelResource {
    private IWorkbook workbook;
    private Set<String> labels = new HashSet<String>();
    private Map<String, Set<ITopic>> labelToTopics = new HashMap<String, Set<ITopic>>();

    public LabelResourceForWorkbook(IWorkbook workbook) {
        Assert.isNotNull((Object)workbook);
        this.workbook = workbook;
        this.init(false);
    }

    private void init(boolean update) {
        if (update) {
            this.labels.clear();
            this.labelToTopics.clear();
        }
        this.collectResourceForWorkbook(this.workbook);
    }

    @Override
    protected void collectResourceForTopic(ITopic topic) {
        Set labs = topic.getLabels();
        for (String lab : labs) {
            Set<Object> topics;
            if (this.labelToTopics.containsKey(lab)) {
                topics = this.labelToTopics.get(lab);
                if (topics == null) {
                    topics = new HashSet();
                }
                topics.add(topic);
                continue;
            }
            topics = new HashSet<ITopic>();
            topics.add(topic);
            this.labelToTopics.put(lab, topics);
        }
        this.labels.addAll(labs);
    }

    @Override
    public Object getSource() {
        return this.workbook;
    }

    @Override
    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public Set<ITopic> getTopics(String label) {
        return this.labelToTopics.get(label);
    }

    @Override
    public void reset(Object source, boolean update) {
        Assert.isNotNull((Object)source);
        this.workbook = (IWorkbook)source;
        this.init(update);
    }
}

