/* rnaPLFold.c was originally generated by the autoSql program, which also 
 * generated rnaPLFold.h and rnaPLFold.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "rnaPLFold.h"


void rnaPLFoldStaticLoad(char **row, struct rnaPLFold *ret)
/* Load a row from rnaPLFold table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->span = sqlUnsigned(row[3]);
ret->colorIndex = row[4];
}

struct rnaPLFold *rnaPLFoldLoad(char **row)
/* Load a rnaPLFold from row fetched with select * from rnaPLFold
 * from database.  Dispose of this with rnaPLFoldFree(). */
{
struct rnaPLFold *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->span = sqlUnsigned(row[3]);
ret->colorIndex = cloneString(row[4]);
return ret;
}

struct rnaPLFold *rnaPLFoldLoadAll(char *fileName) 
/* Load all rnaPLFold from a whitespace-separated file.
 * Dispose of this with rnaPLFoldFreeList(). */
{
struct rnaPLFold *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = rnaPLFoldLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rnaPLFold *rnaPLFoldLoadAllByChar(char *fileName, char chopper) 
/* Load all rnaPLFold from a chopper separated file.
 * Dispose of this with rnaPLFoldFreeList(). */
{
struct rnaPLFold *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = rnaPLFoldLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rnaPLFold *rnaPLFoldCommaIn(char **pS, struct rnaPLFold *ret)
/* Create a rnaPLFold out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rnaPLFold */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->span = sqlUnsignedComma(&s);
ret->colorIndex = sqlStringComma(&s);
*pS = s;
return ret;
}

void rnaPLFoldFree(struct rnaPLFold **pEl)
/* Free a single dynamically allocated rnaPLFold such as created
 * with rnaPLFoldLoad(). */
{
struct rnaPLFold *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->colorIndex);
freez(pEl);
}

void rnaPLFoldFreeList(struct rnaPLFold **pList)
/* Free a list of dynamically allocated rnaPLFold's */
{
struct rnaPLFold *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    rnaPLFoldFree(&el);
    }
*pList = NULL;
}

void rnaPLFoldOutput(struct rnaPLFold *el, FILE *f, char sep, char lastSep) 
/* Print out rnaPLFold.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
fprintf(f, "%u", el->span);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->colorIndex);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

