/* ccdsGeneMap.h was originally generated by the autoSql program, which also 
 * generated ccdsGeneMap.c and ccdsGeneMap.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CCDSGENEMAP_H
#define CCDSGENEMAP_H

#define CCDSGENEMAP_NUM_COLS 6

struct ccdsGeneMap
/* mapping between CCDS ids and other gene tables by similarity */
    {
    struct ccdsGeneMap *next;  /* Next in singly linked list. */
    char *ccdsId;	/* CCDS id with version  */
    char *geneId;	/* Id of other gene */
    char *chrom;	/* chromosome of other gene */
    unsigned chromStart;	/* chromosome start of other gene */
    unsigned chromEnd;	/* chromosome end of other gene */
    float cdsSimilarity;	/* CDS similarity by genomic overlap */
    };

void ccdsGeneMapStaticLoad(char **row, struct ccdsGeneMap *ret);
/* Load a row from ccdsGeneMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ccdsGeneMap *ccdsGeneMapLoad(char **row);
/* Load a ccdsGeneMap from row fetched with select * from ccdsGeneMap
 * from database.  Dispose of this with ccdsGeneMapFree(). */

struct ccdsGeneMap *ccdsGeneMapLoadAll(char *fileName);
/* Load all ccdsGeneMap from whitespace-separated file.
 * Dispose of this with ccdsGeneMapFreeList(). */

struct ccdsGeneMap *ccdsGeneMapLoadAllByChar(char *fileName, char chopper);
/* Load all ccdsGeneMap from chopper separated file.
 * Dispose of this with ccdsGeneMapFreeList(). */

#define ccdsGeneMapLoadAllByTab(a) ccdsGeneMapLoadAllByChar(a, '\t');
/* Load all ccdsGeneMap from tab separated file.
 * Dispose of this with ccdsGeneMapFreeList(). */

struct ccdsGeneMap *ccdsGeneMapCommaIn(char **pS, struct ccdsGeneMap *ret);
/* Create a ccdsGeneMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ccdsGeneMap */

void ccdsGeneMapFree(struct ccdsGeneMap **pEl);
/* Free a single dynamically allocated ccdsGeneMap such as created
 * with ccdsGeneMapLoad(). */

void ccdsGeneMapFreeList(struct ccdsGeneMap **pList);
/* Free a list of dynamically allocated ccdsGeneMap's */

void ccdsGeneMapOutput(struct ccdsGeneMap *el, FILE *f, char sep, char lastSep);
/* Print out ccdsGeneMap.  Separate fields with sep. Follow last field with lastSep. */

#define ccdsGeneMapTabOut(el,f) ccdsGeneMapOutput(el,f,'\t','\n');
/* Print out ccdsGeneMap as a line in a tab-separated file. */

#define ccdsGeneMapCommaOut(el,f) ccdsGeneMapOutput(el,f,',',',');
/* Print out ccdsGeneMap as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

char *ccdsGeneMapGetCreateSql(char *table);
/* Get SQL command to create ccdsGeneMap table. Result should be freed. */

struct ccdsGeneMap *ccdsGeneMapSelectByCcds(struct sqlConnection *conn, char *mapTable,
                                            char *ccdsId, char *chrom, float minSimilarity);
/* select ccdsGeneMap records by ccds and minimum CDS similarity from the
 * specified table. */

struct ccdsGeneMap *ccdsGeneMapSelectByGene(struct sqlConnection *conn, char *mapTable,
                                            char *geneId, float minSimilarity);
/* select ccdsGeneMap records by gene id and minimum CDS similarity from the
 * specified table. */

struct ccdsGeneMap *ccdsGeneMapSelectByGeneOver(struct sqlConnection *conn, char *mapTable,
                                                char *geneId, char *chrom, unsigned chromStart,
                                                unsigned chromEnd, float minSimilarity);
/* select ccdsGeneMap records by gene id, location overlap, and minimum CDS
 * similarity from the specified table. */

int ccdsGeneMapSimilarityCmp(const void *va, const void *vb);
/* compare based on descending similarity */

int ccdsGeneMapCcdsIdCmp(const void *va, const void *vb);
/* compare based on gene id */

int ccdsGeneMapGeneIdCmp(const void *va, const void *vb);
/* compare based on gene id */

#endif /* CCDSGENEMAP_H */

