/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.server.handlers.StaticResourceHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class TestResourceHandler
implements RequestHandler {
    private static final String TIME_IN_THE_PAST = "Sat, 22 Sep 1984 00:00:00 GMT";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final FilesCache filesCache;

    @Inject
    public TestResourceHandler(HttpServletRequest request, HttpServletResponse response, FilesCache filesCache) {
        this.request = request;
        this.response = response;
        this.filesCache = filesCache;
    }

    public void handleIt() throws IOException {
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "private, no-cache, no-store, max-age=0, must-revalidate");
        this.response.setHeader("Expires", TIME_IN_THE_PAST);
        this.response.setHeader("Content-Type", "text/plain");
        this.service(this.request.getPathInfo().substring(1), this.response.getWriter());
    }

    public void service(String fileName, PrintWriter writer) {
        String mimeType = this.parseMimeType(fileName);
        if (mimeType != null) {
            this.response.setContentType(mimeType);
        }
        String data = this.filesCache.getFileContent(fileName);
        writer.write(data);
        writer.flush();
    }

    private String parseMimeType(String fileName) {
        int extension = fileName.lastIndexOf(".");
        if (extension == -1) {
            return null;
        }
        return StaticResourceHandler.MIME_TYPE_MAP.get(fileName.substring(extension + 1));
    }
}

