/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.resolver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.system.resolver.StringResolver;

public class MethodResolver
implements StringResolver {
    @Override
    public String resolve(String string, ClassLoader loader) {
        String parsed = string;
        Matcher matcher = Pattern.compile("(?<!\\\\)\\$M\\{((?:[a-zA-Z_][a-zA-Z_0-9]*\\.)+[a-zA-Z_][a-zA-Z_0-9]*)\\.([a-zA-Z_][a-zA-Z_0-9]*)\\(\\)\\}").matcher(parsed);
        while (matcher.find()) {
            String classname = matcher.group(1);
            String methodname = matcher.group(2);
            try {
                Object object;
                Method method = loader.loadClass(classname).getMethod(methodname, new Class[0]);
                if (method == null || (object = method.invoke(null, new Object[0])) == null) continue;
                String value = object.toString();
                parsed = parsed.replace(matcher.group(), value);
            }
            catch (IllegalArgumentException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (SecurityException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (ClassNotFoundException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (IllegalAccessException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (NoSuchMethodException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            catch (InvocationTargetException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
        }
        return parsed;
    }
}

