/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.schematron.SchematronProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.schematron.IfValidHandler;
import com.thaiopensource.validate.schematron.SchemaImpl;
import com.thaiopensource.validate.schematron.TransformerFactoryInitializer;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class SchemaReaderImpl
extends AbstractSchemaReader {
    static final String SCHEMATRON_URI = "http://www.ascc.net/xml/schematron";
    private static final String LOCATION_URI = "http://www.thaiopensource.com/ns/location";
    private static final String ERROR_URI = "http://www.thaiopensource.com/ns/error";
    private final Localizer localizer = new Localizer(SchemaReaderImpl.class);
    private final Class<? extends SAXTransformerFactory> transformerFactoryClass;
    private final TransformerFactoryInitializer transformerFactoryInitializer;
    private final Templates schematron;
    private final Schema schematronSchema;
    private static final String SCHEMATRON_SCHEMA = "schematron.rnc";
    private static final String SCHEMATRON_STYLESHEET = "schematron.xsl";
    private static final String SCHEMATRON_XSLTC_STYLESHEET = "schematron-xsltc.xsl";
    private static final PropertyId<?>[] supportedPropertyIds = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, SchematronProperty.DIAGNOSE, SchematronProperty.PHASE};

    SchemaReaderImpl(SAXTransformerFactory sAXTransformerFactory, TransformerFactoryInitializer transformerFactoryInitializer) throws TransformerConfigurationException, IncorrectSchemaException {
        this.transformerFactoryClass = sAXTransformerFactory.getClass();
        this.transformerFactoryInitializer = transformerFactoryInitializer;
        boolean bl = SchemaReaderImpl.isXsltc(this.transformerFactoryClass);
        String string = bl ? SCHEMATRON_XSLTC_STYLESHEET : SCHEMATRON_STYLESHEET;
        String string2 = SchemaReaderImpl.fullResourceName(string);
        StreamSource streamSource = new StreamSource(SchemaReaderImpl.getResourceAsStream(string2));
        this.initTransformerFactory(sAXTransformerFactory);
        this.schematron = sAXTransformerFactory.newTemplates(streamSource);
        InputSource inputSource = new InputSource(SchemaReaderImpl.getResourceAsStream(SchemaReaderImpl.fullResourceName(SCHEMATRON_SCHEMA)));
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, new DraconianErrorHandler());
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        try {
            this.schematronSchema = CompactSchemaReader.getInstance().createSchema(inputSource, propertyMapBuilder.toPropertyMap());
        }
        catch (SAXException sAXException) {
            throw new IncorrectSchemaException();
        }
        catch (IOException iOException) {
            throw new IncorrectSchemaException();
        }
    }

    static boolean isXsltc(Class<? extends SAXTransformerFactory> clazz) {
        return clazz.getName().indexOf(".xsltc.") >= 0;
    }

    @Override
    public Option getOption(String string) {
        return SchematronProperty.getOption(string);
    }

    private void initTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactoryInitializer.initTransformerFactory(transformerFactory);
    }

    @Override
    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER);
        CountingErrorHandler countingErrorHandler = new CountingErrorHandler(errorHandler);
        InputSource inputSource = sAXSource.getInputSource();
        String string = inputSource.getSystemId();
        IfValidHandler ifValidHandler = new IfValidHandler();
        ifValidHandler.setErrorHandler(countingErrorHandler);
        try {
            boolean bl;
            SAXTransformerFactory sAXTransformerFactory = this.transformerFactoryClass.newInstance();
            this.initTransformerFactory(sAXTransformerFactory);
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(this.schematron);
            ifValidHandler.setDelegate(transformerHandler);
            Transformer transformer = transformerHandler.getTransformer();
            String string2 = propertyMap.get(SchematronProperty.PHASE);
            if (string2 != null) {
                transformer.setParameter("phase", string2);
            }
            if (bl = propertyMap.contains(SchematronProperty.DIAGNOSE)) {
                transformer.setParameter("diagnose", Boolean.TRUE);
            }
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
            propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, ifValidHandler);
            Validator validator = this.schematronSchema.createValidator(propertyMapBuilder.toPropertyMap());
            ifValidHandler.setValidator(validator.getContentHandler());
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader == null) {
                xMLReader = ResolverFactory.createResolver(propertyMap).createXMLReader();
            }
            xMLReader.setContentHandler(ifValidHandler);
            xMLReader.setDTDHandler(validator.getDTDHandler());
            sAXTransformerFactory.setErrorListener(new SAXErrorListener(countingErrorHandler, string));
            TemplatesHandler templatesHandler = sAXTransformerFactory.newTemplatesHandler();
            templatesHandler.setSystemId(string);
            LocationFilter locationFilter = new LocationFilter(new ErrorFilter(templatesHandler, countingErrorHandler, this.localizer), string);
            transformerHandler.setResult(new SAXResult(locationFilter));
            xMLReader.setErrorHandler(countingErrorHandler);
            xMLReader.parse(inputSource);
            SAXException sAXException = locationFilter.getException();
            if (sAXException != null) {
                throw sAXException;
            }
            if (countingErrorHandler.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Templates templates = templatesHandler.getTemplates();
            if (countingErrorHandler.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            return new SchemaImpl(templates, this.transformerFactoryClass, propertyMap, supportedPropertyIds);
        }
        catch (SAXException sAXException) {
            throw SchemaReaderImpl.cleanupSAXException(sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(this.localizer.message("unexpected_schema_creation_error"));
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(illegalAccessException);
        }
    }

    private static String fullResourceName(String string) {
        String string2 = SchemaReaderImpl.class.getName();
        return string2.substring(0, string2.lastIndexOf(46)).replace('.', '/') + "/resources/" + string;
    }

    private static InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = SchemaReaderImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    private static SAXException cleanupSAXException(SAXException sAXException) {
        if (SchemaReaderImpl.exceptionHasLocation(sAXException)) {
            return sAXException;
        }
        Exception exception = sAXException.getException();
        if (exception instanceof SAXException && exception.getMessage() == null) {
            return SchemaReaderImpl.cleanupSAXException((SAXException)exception);
        }
        if (exception instanceof TransformerException) {
            return SchemaReaderImpl.cleanupTransformerException((TransformerException)exception);
        }
        return sAXException;
    }

    private static SAXException cleanupTransformerException(TransformerException transformerException) {
        String string = transformerException.getMessage();
        Throwable throwable = transformerException.getException();
        SourceLocator sourceLocator = transformerException.getLocator();
        if (string != null && throwable != null && string.equals(throwable.toString())) {
            string = null;
        }
        if (string == null && throwable instanceof SAXException && sourceLocator == null) {
            return SchemaReaderImpl.cleanupSAXException((SAXException)throwable);
        }
        if (throwable instanceof TransformerException && sourceLocator == null) {
            return SchemaReaderImpl.cleanupTransformerException((TransformerException)throwable);
        }
        Exception exception = null;
        if (throwable instanceof Exception) {
            exception = (Exception)throwable;
        }
        String string2 = null;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        if (sourceLocator != null) {
            string2 = sourceLocator.getPublicId();
            string3 = sourceLocator.getSystemId();
            n = sourceLocator.getLineNumber();
            n2 = sourceLocator.getColumnNumber();
        }
        if (string2 != null || string3 != null || n >= 0 || n2 >= 0) {
            return new SAXParseException(string, string2, string3, n, n2, exception);
        }
        return new SAXException(string, exception);
    }

    private static boolean exceptionHasLocation(SAXException sAXException) {
        if (!(sAXException instanceof SAXParseException)) {
            return false;
        }
        SAXParseException sAXParseException = (SAXParseException)sAXException;
        return sAXParseException.getPublicId() != null || sAXParseException.getSystemId() != null || sAXParseException.getLineNumber() >= 0 || sAXParseException.getColumnNumber() >= 0;
    }

    static class SAXErrorListener
    implements ErrorListener {
        private final ErrorHandler eh;
        private final String systemId;
        private boolean hadError = false;

        SAXErrorListener(ErrorHandler errorHandler, String string) {
            this.eh = errorHandler;
            this.systemId = string;
        }

        boolean getHadError() {
            return this.hadError;
        }

        @Override
        public void warning(TransformerException transformerException) throws TransformerException {
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        @Override
        public void error(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        @Override
        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        SAXParseException transform(TransformerException transformerException) throws TransformerException {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SAXException || throwable instanceof IncorrectSchemaException || throwable instanceof IOException) {
                throw transformerException;
            }
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator == null) {
                return new SAXParseException(transformerException.getMessage(), null);
            }
            String string = sourceLocator.getSystemId();
            if (string == null) {
                string = this.systemId;
            }
            return new SAXParseException(transformerException.getMessage(), sourceLocator.getPublicId(), string, sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
        }
    }

    static class LocationFilter
    extends DelegatingContentHandler
    implements Locator {
        private final String mainSystemId;
        private String systemId = null;
        private int lineNumber = -1;
        private int columnNumber = -1;
        private SAXException exception = null;

        LocationFilter(ContentHandler contentHandler, String string) {
            super(contentHandler);
            this.mainSystemId = string;
        }

        SAXException getException() {
            return this.exception;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
            this.getDelegate().setDocumentLocator(this);
            super.startDocument();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.systemId = LocationFilter.getLocationAttribute(attributes, "system-id");
            this.lineNumber = LocationFilter.toInteger(LocationFilter.getLocationAttribute(attributes, "line-number"));
            this.columnNumber = LocationFilter.toInteger(LocationFilter.getLocationAttribute(attributes, "column-number"));
            try {
                super.startElement(string, string2, string3, attributes);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
                this.setDelegate(null);
            }
            this.systemId = null;
            this.lineNumber = -1;
            this.columnNumber = -1;
        }

        private static String getLocationAttribute(Attributes attributes, String string) {
            return attributes.getValue(SchemaReaderImpl.LOCATION_URI, string);
        }

        private static int toInteger(String string) {
            if (string == null) {
                return -1;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            if (this.systemId != null && !this.systemId.equals("")) {
                return this.systemId;
            }
            return this.mainSystemId;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    static class ErrorFilter
    extends DelegatingContentHandler {
        private final ErrorHandler eh;
        private final Localizer localizer;
        private Locator locator;

        ErrorFilter(ContentHandler contentHandler, ErrorHandler errorHandler, Localizer localizer) {
            super(contentHandler);
            this.eh = errorHandler;
            this.localizer = localizer;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string.equals(SchemaReaderImpl.ERROR_URI) && string2.equals("error")) {
                this.eh.error(new SAXParseException(this.localizer.message(attributes.getValue("", "message"), attributes.getValue("", "arg")), this.locator));
            }
            super.startElement(string, string2, string3, attributes);
        }
    }

    static class UserWrapErrorHandler
    extends CountingErrorHandler {
        UserWrapErrorHandler(ErrorHandler errorHandler) {
            super(errorHandler);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            try {
                super.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            try {
                super.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            try {
                super.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }
    }

    static class UserException
    extends Exception {
        private final SAXException exception;

        UserException(SAXException sAXException) {
            this.exception = sAXException;
        }

        SAXException getException() {
            return this.exception;
        }
    }
}

