/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.index.IndexCollator;
import org.dita.index.IndexEntry;
import org.dita.index.IndexGroup;
import org.dita.index.IndexGroupImpl;
import org.dita.index.IndexPreprocessorTask;
import org.dita.index.configuration.ConfigEntry;
import org.dita.index.configuration.IndexConfiguration;

public final class IndexGroupProcessor {
    private DITAOTLogger logger;
    private static final String SPECIAL_CHARACTER_GROUP_KEY = "Specials";

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public List<IndexGroup> process(Collection<IndexEntry> indexEntries, IndexConfiguration indexConfiguration, Locale locale) {
        ConfigEntry configEntry;
        int i;
        IndexCollator collator = new IndexCollator(locale);
        ArrayList<IndexGroupImpl> result = new ArrayList<IndexGroupImpl>();
        List<ConfigEntry> entries = indexConfiguration.getEntries();
        Map<String, IndexEntry> indexMap = IndexGroupProcessor.createMap(indexEntries);
        for (ConfigEntry configEntry2 : entries) {
            String label = configEntry2.getLabel();
            IndexGroupImpl group = new IndexGroupImpl(label, configEntry2);
            result.add(group);
        }
        ArrayList<IndexGroupImpl> indexGroups = result;
        for (i = 0; i < indexGroups.size(); ++i) {
            IndexGroupImpl thisGroup = (IndexGroupImpl)indexGroups.get(i);
            List<String> thisGroupMembers = thisGroup.getConfigEntry().getGroupMembers();
            for (int j = 0; j < indexGroups.size(); ++j) {
                IndexGroupImpl compGroup;
                Object compGroupMembers;
                if (j == i || !IndexGroupProcessor.doesStart(compGroupMembers = (compGroup = (IndexGroupImpl)indexGroups.get(j)).getConfigEntry().getGroupMembers(), thisGroupMembers)) continue;
                thisGroup.addChild(compGroup);
            }
        }
        for (i = 0; i < indexGroups.size(); ++i) {
            Object value;
            IndexGroupImpl group = (IndexGroupImpl)indexGroups.get(i);
            configEntry = group.getConfigEntry();
            List<String> groupMembers = configEntry.getGroupMembers();
            if (!groupMembers.isEmpty()) {
                ArrayList<String> keys = new ArrayList<String>(indexMap.keySet());
                for (String key : keys) {
                    if (key.isEmpty() || !configEntry.isInRange((String)(value = IndexGroupProcessor.getValue(indexMap.get(key))), collator)) continue;
                    IndexEntry entry = indexMap.remove(key);
                    group.addEntry(entry);
                }
                continue;
            }
            String key1 = configEntry.getKey();
            String key2 = null;
            if (entries.size() > i + 1) {
                ConfigEntry nextEntry = entries.get(i + 1);
                key2 = nextEntry.getKey();
            }
            List<String> indexMapKeys = IndexGroupProcessor.getIndexKeysOfIndexesInRange(key1, key2, collator, indexMap);
            value = indexMapKeys.iterator();
            while (value.hasNext()) {
                String mapKey = value.next();
                IndexEntry entry = indexMap.remove(mapKey);
                group.addEntry(entry);
            }
        }
        for (IndexGroupImpl group : indexGroups) {
            configEntry = group.getConfigEntry();
            String configKey = configEntry.getKey();
            if (!configKey.equals(SPECIAL_CHARACTER_GROUP_KEY)) continue;
            for (String key : new ArrayList<String>(indexMap.keySet())) {
                if (key.isEmpty()) continue;
                String value = IndexGroupProcessor.getValue(indexMap.get(key));
                this.logger.info(MessageUtils.getMessage((String)"INDX001I", (String[])new String[]{value}).toString());
                IndexEntry entry = indexMap.remove(key);
                group.addEntry(entry);
            }
        }
        if (!indexMap.isEmpty()) {
            for (String key : new ArrayList<String>(indexMap.keySet())) {
                if (key.isEmpty()) continue;
                IndexEntry entry = indexMap.get(key);
                this.logger.error(MessageUtils.getMessage((String)"INDX002E", (String[])new String[]{entry.toString()}).toString());
            }
            if (IndexPreprocessorTask.failOnError) {
                this.logger.error(MessageUtils.getMessage((String)"INDX003E", (String[])new String[0]).toString());
                IndexPreprocessorTask.processingFaild = true;
            }
        }
        ArrayList<IndexGroup> cleanResult = new ArrayList<IndexGroup>();
        for (IndexGroupImpl indexGroup : indexGroups) {
            if (indexGroup.getEntries().isEmpty()) continue;
            cleanResult.add(indexGroup);
        }
        return cleanResult;
    }

    private static String getValue(IndexEntry entry) {
        String sortValue = entry.getSortString();
        if (sortValue != null && sortValue.length() > 0) {
            return sortValue;
        }
        return entry.getValue();
    }

    private static List<String> getIndexKeysOfIndexesInRange(String key1, String key2, IndexCollator collator, Map<String, IndexEntry> indexEntryMap) {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, IndexEntry> e : indexEntryMap.entrySet()) {
            int res1 = collator.compare(key1, IndexGroupProcessor.getValue(e.getValue()));
            if (res1 > 0) continue;
            if (key2 == null) {
                res.add(e.getKey());
                continue;
            }
            int res2 = collator.compare(key2, e.getKey());
            if (res2 <= 0) continue;
            res.add(e.getKey());
        }
        return res;
    }

    @Deprecated
    private static boolean doesStart(String sourceString, List<String> compStrings) {
        for (String compString : compStrings) {
            if (!sourceString.startsWith(compString)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesStart(List<String> sourceStrings, List<String> compStrings) {
        for (String sourceString2 : sourceStrings) {
            for (String compString : compStrings) {
                if (!sourceString2.startsWith(compString) || sourceString2.equals(compString)) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, IndexEntry> createMap(Collection<IndexEntry> indexEntries) {
        HashMap<String, IndexEntry> map = new HashMap<String, IndexEntry>();
        for (IndexEntry indexEntrie : indexEntries) {
            List<IndexEntry> list;
            String value = indexEntrie.getValue();
            if (!map.containsKey(value)) {
                map.put(value, indexEntrie);
                continue;
            }
            IndexEntry existingEntry = (IndexEntry)map.get(value);
            List<IndexEntry> childIndexEntries = indexEntrie.getChildIndexEntries();
            for (IndexEntry indexEntry : childIndexEntries) {
                existingEntry.addChild(indexEntry);
            }
            List<IndexEntry> seeChildIndexEntries = indexEntrie.getSeeChildIndexEntries();
            if (seeChildIndexEntries != null) {
                for (Object seeChildIndexEntry : seeChildIndexEntries) {
                    existingEntry.addSeeChild((IndexEntry)seeChildIndexEntry);
                }
            }
            if ((list = indexEntrie.getSeeAlsoChildIndexEntries()) != null) {
                Object seeChildIndexEntry;
                seeChildIndexEntry = list.iterator();
                while (seeChildIndexEntry.hasNext()) {
                    IndexEntry seeAlsoChildIndexEntry = (IndexEntry)seeChildIndexEntry.next();
                    existingEntry.addSeeAlsoChild(seeAlsoChildIndexEntry);
                }
            }
            if (indexEntrie.isRestoresPageNumber()) {
                existingEntry.setRestoresPageNumber(true);
            }
            Set<String> refIDs = indexEntrie.getRefIDs();
            for (String refID : refIDs) {
                existingEntry.addRefID(refID);
            }
            if (!indexEntrie.isSuppressesThePageNumber()) {
                existingEntry.setSuppressesThePageNumber(false);
            }
            if (!indexEntrie.isStartingRange()) continue;
            existingEntry.setStartRange(true);
        }
        return map;
    }
}

