/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;

public class DefaultJvmLanguageSourceDirectoryBuilder
implements JvmLanguageSourceDirectoryBuilder {
    private final String name;
    private final ProjectInternal project;
    private final SourceSet sourceSet;
    private String description;
    private Function<DirectoryProperty, TaskProvider<? extends AbstractCompile>> taskBuilder;
    private boolean includeInAllJava;

    @Inject
    public DefaultJvmLanguageSourceDirectoryBuilder(String name, ProjectInternal project, SourceSet sourceSet) {
        this.name = name;
        this.project = project;
        this.sourceSet = sourceSet;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledBy(Function<DirectoryProperty, TaskProvider<? extends AbstractCompile>> taskBuilder) {
        this.taskBuilder = taskBuilder;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledWithJava(Action<? super JavaCompile> compilerConfiguration) {
        Function<DirectoryProperty, TaskProvider<? extends AbstractCompile>> t = sourceDirectory -> this.project.getTasks().register("compile" + StringUtils.capitalize((String)this.name), JavaCompile.class, compileTask -> {
            compileTask.source(new Object[]{sourceDirectory});
            compileTask.setClasspath(this.sourceSet.getCompileClasspath());
            compilerConfiguration.execute(compileTask);
        });
        return this.includeInAllJava().compiledBy(t);
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder includeInAllJava() {
        this.includeInAllJava = true;
        return this;
    }

    void build() {
        if (this.taskBuilder == null) {
            throw new IllegalStateException("You must specify the task which will contribute classes from this source directory");
        }
        SourceDirectorySet langSrcDir = this.project.getObjects().sourceDirectorySet(this.name, this.description == null ? "Sources for " + this.name : this.description);
        langSrcDir.srcDir((Object)this.project.getLayout().getProjectDirectory().dir("src/" + this.sourceSet.getName() + "/" + this.name));
        Provider srcDirProvider = this.project.getProviders().provider(() -> langSrcDir.getSourceDirectories().getSingleFile());
        TaskProvider<? extends AbstractCompile> compileTask = this.taskBuilder.apply(this.project.getObjects().directoryProperty().fileProvider(srcDirProvider));
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(this.sourceSet, langSrcDir, (Project)this.project, compileTask, (Provider<CompileOptions>)compileTask.map(task -> {
            if (task instanceof HasCompileOptions) {
                return ((HasCompileOptions)task).getOptions();
            }
            throw new UnsupportedOperationException("Unsupported compile task " + task.getClass().getName());
        }));
        if (this.includeInAllJava) {
            this.sourceSet.getAllJava().source(langSrcDir);
        }
        this.sourceSet.getAllSource().source(langSrcDir);
        this.project.getTasks().named("classes").configure(classes -> classes.dependsOn(new Object[]{compileTask}));
    }
}

