/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.normalization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.ApiMemberWriter;
import org.gradle.internal.normalization.java.impl.ArrayAnnotationValue;
import org.gradle.internal.normalization.java.impl.ClassMember;
import org.gradle.internal.normalization.java.impl.FieldMember;
import org.gradle.internal.normalization.java.impl.InnerClassMember;
import org.gradle.internal.normalization.java.impl.MethodMember;
import org.gradle.internal.normalization.java.impl.SimpleAnnotationValue;
import org.gradle.kotlin.dsl.normalization.CompileAvoidanceException;
import org.gradle.kotlin.dsl.normalization.KotlinApiMemberWriter;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016J\u0016\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0014J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0019H\u0014J\f\u0010\"\u001a\u00020\u0007*\u00020\u0019H\u0002J\f\u0010#\u001a\u00020\u0014*\u00020$H\u0002J\f\u0010%\u001a\u00020\u0014*\u00020$H\u0002J\f\u0010&\u001a\u00020\u0014*\u00020$H\u0002J\f\u0010'\u001a\u00020(*\u00020\u0019H\u0002J\f\u0010)\u001a\u00020(*\u00020\u0019H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter;", "Lorg/gradle/internal/normalization/java/impl/ApiMemberWriter;", "apiMemberAdapter", "Lorg/objectweb/asm/ClassVisitor;", "(Lorg/objectweb/asm/ClassVisitor;)V", "inlineFunctions", "", "", "getInlineFunctions", "()Ljava/util/Set;", "internalFunctions", "getInternalFunctions", "kotlinMetadataAnnotationSignature", "getKotlinMetadataAnnotationSignature", "()Ljava/lang/String;", "parseKotlinClassHeader", "Lkotlinx/metadata/jvm/KotlinClassHeader;", "kotlinMetadataAnnotation", "Lorg/gradle/internal/normalization/java/impl/AnnotationMember;", "writeClass", "", "classMember", "Lorg/gradle/internal/normalization/java/impl/ClassMember;", "methods", "", "Lorg/gradle/internal/normalization/java/impl/MethodMember;", "fields", "Lorg/gradle/internal/normalization/java/impl/FieldMember;", "innerClasses", "Lorg/gradle/internal/normalization/java/impl/InnerClassMember;", "writeClassAnnotations", "annotationMembers", "writeMethod", "method", "binarySignature", "extractFunctionMetadata", "Lkotlinx/metadata/KmDeclarationContainer;", "extractInlineFunctions", "extractInternalFunctions", "isInline", "", "isInternal", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nKotlinApiClassExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinApiClassExtractor.kt\norg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,175:1\n288#2,2:176\n766#2:178\n857#2,2:179\n1855#2:181\n1856#2:194\n11065#3:182\n11400#3,3:183\n11065#3:188\n11400#3,3:189\n37#4,2:186\n37#4,2:192\n*S KotlinDebug\n*F\n+ 1 KotlinApiClassExtractor.kt\norg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter\n*L\n66#1:176,2\n91#1:178\n91#1:179,2\n135#1:181\n135#1:194\n148#1:182\n148#1:183,3\n149#1:188\n149#1:189,3\n148#1:186,2\n149#1:192,2\n*E\n"})
final class KotlinApiMemberWriter
extends ApiMemberWriter {
    @NotNull
    private final String kotlinMetadataAnnotationSignature;
    @NotNull
    private final Set<String> inlineFunctions;
    @NotNull
    private final Set<String> internalFunctions;

    public KotlinApiMemberWriter(@NotNull ClassVisitor apiMemberAdapter) {
        Intrinsics.checkNotNullParameter((Object)apiMemberAdapter, (String)"apiMemberAdapter");
        super(apiMemberAdapter);
        this.kotlinMetadataAnnotationSignature = "Lkotlin/Metadata;";
        this.inlineFunctions = new HashSet();
        this.internalFunctions = new HashSet();
    }

    @NotNull
    public final String getKotlinMetadataAnnotationSignature() {
        return this.kotlinMetadataAnnotationSignature;
    }

    @NotNull
    public final Set<String> getInlineFunctions() {
        return this.inlineFunctions;
    }

    @NotNull
    public final Set<String> getInternalFunctions() {
        return this.internalFunctions;
    }

    public void writeClass(@NotNull ClassMember classMember, @NotNull Set<? extends MethodMember> methods, @NotNull Set<? extends FieldMember> fields, @NotNull Set<? extends InnerClassMember> innerClasses) {
        Object v1;
        block11: {
            Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter(innerClasses, (String)"innerClasses");
            SortedSet sortedSet = classMember.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"classMember.annotations");
            Iterable $this$firstOrNull$iv = sortedSet;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationMember it = (AnnotationMember)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.kotlinMetadataAnnotationSignature)) continue;
                v1 = element$iv;
                break block11;
            }
            v1 = null;
        }
        AnnotationMember annotationMember = v1;
        if (annotationMember != null) {
            AnnotationMember it = annotationMember;
            boolean bl = false;
            KotlinClassMetadata kotlinMetadata = KotlinClassMetadata.Companion.read(this.parseKotlinClassHeader(it));
            if (kotlinMetadata instanceof KotlinClassMetadata.Class) {
                this.extractFunctionMetadata((KmDeclarationContainer)((KotlinClassMetadata.Class)kotlinMetadata).toKmClass());
            } else if (kotlinMetadata instanceof KotlinClassMetadata.FileFacade) {
                this.extractFunctionMetadata((KmDeclarationContainer)((KotlinClassMetadata.FileFacade)kotlinMetadata).toKmPackage());
            } else if (kotlinMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
                this.extractFunctionMetadata((KmDeclarationContainer)((KotlinClassMetadata.MultiFileClassPart)kotlinMetadata).toKmPackage());
            } else if (!(kotlinMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) && !(kotlinMetadata instanceof KotlinClassMetadata.SyntheticClass)) {
                if (kotlinMetadata instanceof KotlinClassMetadata.Unknown) {
                    throw new CompileAvoidanceException("Unknown Kotlin metadata with kind: " + ((KotlinClassMetadata.Unknown)kotlinMetadata).getHeader().getKind() + " on class " + classMember.getName() + " - this can happen if this class is compiled with a later Kotlin version than the Kotlin compiler used by Gradle");
                }
                if (kotlinMetadata == null) {
                    // empty if block
                }
            }
        }
        super.writeClass(classMember, methods, fields, innerClasses);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeClassAnnotations(@NotNull Set<? extends AnnotationMember> annotationMembers) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(annotationMembers, (String)"annotationMembers");
        Iterable iterable = annotationMembers;
        KotlinApiMemberWriter kotlinApiMemberWriter = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationMember it = (AnnotationMember)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)this.kotlinMetadataAnnotationSignature))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        super.writeClassAnnotations(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    protected void writeMethod(@NotNull MethodMember method2) {
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        if (this.isInternal(method2)) {
            return;
        }
        if (this.isInline(method2)) {
            throw CompileAvoidanceException.Factory.publicInlineFunction(method2);
        }
        super.writeMethod(method2);
    }

    private final void extractFunctionMetadata(KmDeclarationContainer $this$extractFunctionMetadata) {
        this.extractInternalFunctions($this$extractFunctionMetadata);
        this.extractInlineFunctions($this$extractFunctionMetadata);
    }

    private final void extractInlineFunctions(KmDeclarationContainer $this$extractInlineFunctions) {
        CollectionsKt.addAll((Collection)this.inlineFunctions, (Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$extractInlineFunctions.getFunctions()), (Function1)extractInlineFunctions.1.INSTANCE), (Function1)extractInlineFunctions.2.INSTANCE));
    }

    private final void extractInternalFunctions(KmDeclarationContainer $this$extractInternalFunctions) {
        CollectionsKt.addAll((Collection)this.internalFunctions, (Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$extractInternalFunctions.getFunctions()), (Function1)extractInternalFunctions.1.INSTANCE), (Function1)extractInternalFunctions.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinClassHeader parseKotlinClassHeader(AnnotationMember kotlinMetadataAnnotation) {
        Integer kind = null;
        int[] metadataVersion = null;
        Ref.ObjectRef data1 = new Ref.ObjectRef();
        Ref.ObjectRef data2 = new Ref.ObjectRef();
        String extraString = null;
        String packageName = null;
        Integer extraInt = null;
        SortedSet sortedSet = kotlinMetadataAnnotation.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"kotlinMetadataAnnotation.values");
        Iterable $this$forEach$iv = sortedSet;
        boolean $i$f$forEach = false;
        block15: for (Object element$iv : $this$forEach$iv) {
            AnnotationValue annotationValue;
            AnnotationValue it;
            block24: {
                block25: {
                    block28: {
                        block27: {
                            block26: {
                                it = (AnnotationValue)element$iv;
                                boolean bl = false;
                                annotationValue = it;
                                if (!(annotationValue instanceof SimpleAnnotationValue)) break block24;
                                String string = ((SimpleAnnotationValue)it).getName();
                                switch (string.hashCode()) {
                                    case 3825: {
                                        if (!string.equals("xi")) {
                                            continue block15;
                                        }
                                        break block25;
                                    }
                                    case 3497: {
                                        if (!string.equals("mv")) {
                                            continue block15;
                                        }
                                        break block26;
                                    }
                                    case 107: {
                                        if (string.equals("k")) break;
                                        continue block15;
                                    }
                                    case 3835: {
                                        if (!string.equals("xs")) {
                                            continue block15;
                                        }
                                        break block27;
                                    }
                                    case 3582: {
                                        if (!string.equals("pn")) {
                                            continue block15;
                                        }
                                        break block28;
                                    }
                                }
                                Object object = ((SimpleAnnotationValue)it).getValue();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                                kind = (Integer)object;
                                continue;
                            }
                            Object object = ((SimpleAnnotationValue)it).getValue();
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.IntArray");
                            metadataVersion = (int[])object;
                            continue;
                        }
                        Object object = ((SimpleAnnotationValue)it).getValue();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                        extraString = (String)object;
                        continue;
                    }
                    Object object = ((SimpleAnnotationValue)it).getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    packageName = (String)object;
                    continue;
                }
                Object object = ((SimpleAnnotationValue)it).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                extraInt = (Integer)object;
                continue;
            }
            if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
            switch (((ArrayAnnotationValue)it).getName()) {
                case "d1": {
                    Object[] $this$toTypedArray$iv;
                    AnnotationValue arrayItem;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    Object object = ((ArrayAnnotationValue)it).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.value");
                    Object[] objectArray = (Object[])object;
                    Ref.ObjectRef objectRef = data1;
                    boolean $i$f$map = false;
                    void var20_20 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        AnnotationValue annotationValue2 = (AnnotationValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Object object2 = arrayItem.getValue();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)object2);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Object[] thisCollection$iv = $this$toTypedArray$iv;
                    objectRef.element = thisCollection$iv.toArray(new String[0]);
                    break;
                }
                case "d2": {
                    AnnotationValue arrayItem;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    Object object = ((ArrayAnnotationValue)it).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.value");
                    Object[] $this$toTypedArray$iv = (Object[])object;
                    Ref.ObjectRef objectRef = data2;
                    boolean $i$f$map = false;
                    Object[] thisCollection$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        void item$iv$iv;
                        item$iv$iv = $this$mapTo$iv$iv[j];
                        arrayItem = (AnnotationValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Object object3 = arrayItem.getValue();
                        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)object3);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    objectRef.element = thisCollection$iv.toArray(new String[0]);
                }
            }
        }
        return new KotlinClassHeader(kind, metadataVersion, (String[])data1.element, (String[])data2.element, extraString, packageName, extraInt);
    }

    private final String binarySignature(MethodMember $this$binarySignature) {
        return $this$binarySignature.getName() + $this$binarySignature.getTypeDesc();
    }

    private final boolean isInternal(MethodMember $this$isInternal) {
        return this.internalFunctions.contains(this.binarySignature($this$isInternal));
    }

    private final boolean isInline(MethodMember $this$isInline) {
        return this.inlineFunctions.contains(this.binarySignature($this$isInline));
    }
}

