//**************************************************************************************************
//                                         CmdGnuCapOPT.hpp                                        *
//                                        ------------------                                       *
// Description : This class contains values associated with the GNU-CAP OPTIONS command. It        *
//               inherits from the class CmdBase.                                                  *
// Started     : 2006-09-11                                                                        *
// Last Update : 2020-10-20                                                                        *
// Copyright   : (C) 2006-2020 MSWaters                                                            *
//**************************************************************************************************
// Note : The following defaults where generated by GNU-CAP on 2014-03-27 (run gnucap end enter    *
//        options command without arguments) :                                                     *
//                                                                                                 *
//        * i/o                                                                                    *
//        .options  noacct nolist clobber out=9999 ydivisions=4.0 phase=degrees harmonics=9 edit   *
//                  language=acs insensitive units=spice recursion=20                              *
//        * accuracy, i/o                                                                          *
//        .options  numdgt=5 floor=1.E-21 vfloor=1.f roundofftol=100.f                             *
//        * accuracy, tolerances                                                                   *
//        .options  gmin= 1.0p short=10.0u reltol=0.001 abstol=1.0p vntol= 1.0u trtol=7.0          *
//                  chgtol=10.0f pivtol=100.0f bypasstol=0.1 loadtol=0.1                           *
//        * accuracy, algorithms                                                                   *
//        .options  method=trap bypass incmode lcbypass lubypass fbbypass traceload order=auto     *
//                  mode=mixed transits=2 noquitconvfail                                           *
//        * iteration limiting and heuristics                                                      *
//        .options  itl1=100 itl2=50 itl3=6 itl4=20 itl5=0 itl6=5000 itl7=1 itl8=99 itermin=1      *
//                  vmax=5.0 vmin=-5.0 dampmax=1.0 dampmin=0.5 dampstrategy=0                      *
//        * time step control                                                                      *
//        .options  dtmin=1.0p dtratio=1.0G trstepgrow=1.E+99 trstephold=1.E+99 trstepshrink=2.0   *
//                  trreject=0.5 trsteporder=3 trstepcoef1=0.25 trstepcoef2=0.04166667             *
//                  trstepcoef3=0.005208333                                                        *
//        * circuit environment                                                                    *
//        .options  tnom= 27.0 temperature=27.0 rstray cstray defl=100.0u defw=100.0u defad=0.0    *
//                  defas=0.0                                                                      *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef CMDGCPOPT_HPP
#define CMDGCPOPT_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceOPT.hpp"
#include "utility/CnvtType.hpp"

class CmdNgSpiceOPT;

// wxWidgets Includes

#include <wx/tokenzr.h>

// Local Macro and/or Constant Declarations

#define  GCP_ABSTOL    "1.0pA"     // Absolute  error tolerance
#define  GCP_CHGTOL    "10.0fC"    // Charge    error tolerance
#define  GCP_RELTOL    "0.001"     // Relative  error tolerance (0.001 = 0.1%)
#define  GCP_TRTOL     "7.0"       // Transient error tolerance
#define  GCP_VNTOL     "1.0uV"     // Voltage   error tolerance (Volt)
#define  GCP_DEFL      "100.0um"   // MOSFET default channel length (metre)
#define  GCP_DEFW      "100.0um"   // MOSFET default channel width  (metre)
#define  GCP_DEFAD     "0.0"       // MOSFET default drain  diffusion area (sq.m)
#define  GCP_DEFAS     "0.0"       // MOSFET default source diffusion area (sq.m)
#define  GCP_GMIN      "1.0pS"     // Minimum conductance to ground (Siemen)
#define  GCP_SHORT     "100.0nOhm" // Resistance of voltage source or short (Ohm)
#define  GCP_TEMP      "27.0"      // Ambient temperature of the circuit (Deg.C)
#define  GCP_TNOM      "27.0"      // Nominal temperature at which device parameters are measured (Deg.C)
#define  GCP_DAMPMAX   "1.0"       // Newton damping factor in normal  cases
#define  GCP_DAMPMIN   "0.5"       // Newton damping factor in problem cases
#define  GCP_DTMIN     "1.0pSec"   // Smallest internal time step in TR analysis
#define  GCP_DTRATIO   "1.0E9"     // Ratio between min. and max. time step
#define  GCP_TRREJECT  "0.5"       // Transient error rejection threshold
#define  GCP_TRSTEPG   "1.0E99"    // Max. internal step size growth in TR analysis
#define  GCP_TRSTEPH   "1.0E99"    // Max. internal step size growth in TR analysis when iteration exceeds it13 but still converges
#define  GCP_TRSTEPS   "2.0"       // Amount to shrink step size when convergence fails in TR anaylis
#define  GCP_ROUND     "1.0E-13"   // Numeric rounding tolerance
#define  GCP_FLOOR     "1.0E-21"   // Effective zero value
#define  GCP_VFLOOR    "1.0fV"     // Effective zero value for voltage probes
#define  GCP_VMAX      "5.0V"      // Initial positive node voltage limit (Volt)
#define  GCP_VMIN      "-5.0V"     // Initial negative node voltage limit (Volt)

#define  GCP_HARMS     "9"         // Number of harmonics to display in FO analysis
#define  GCP_ITL1      "100"       // DC iteration limit
#define  GCP_ITL2      "50"        // DC transfer curve   iteration limit (not used in GNU-Cap)
#define  GCP_ITL3      "6"         // Transient lower     iteration limit
#define  GCP_ITL4      "20"        // Transient upper     iteration limit
#define  GCP_ITL5      "0"         // Transient total     iteration limit (not used in GNU-Cap)
#define  GCP_ITL6      "5000"      // Source stepping     iteration limit (not used in GNU-Cap)
#define  GCP_ITL7      "1"         // Worst case analysis iteration limit
#define  GCP_ITL8      "100"       // Convergence diagnostic iteration threshold
#define  GCP_ITERMIN   "1"         // Number of extra iterations after convergence
#define  GCP_NUMDGT    "5"         // Precision : no. of digits after decimal point
#define  GCP_RECURS    "20"        // Limit recursion levels in expression evaluation
#define  GCP_TRANSITS  "2"         // Mixed mode transition count

#define  GCP_METHOD    "Trap"      // Differentiation method (TRAPezoidal and/or EULER)
#define  GCP_MODE      "Mixed"     // Simulation mode (analog, digital or mixed)
#define  GCP_ORDER     "Auto"      // Equation ordering (forward, reverse or auto)
#define  GCP_PHASE     "Degrees"   // Phase angle units : degrees or radians

#define  GCP_OPTS      false       // Enable printing of option values
#define  GCP_BYPASS    true        // Bypass model evaluation if appropriate
#define  GCP_FBBYPASS  true        // Skip matrix solution the last iteration
#define  GCP_LCBYPASS  true        // Bypass evaluation of linear ind. & cap. when possible
#define  GCP_LUBYPASS  true        // Bypass parts of LU decomposition if appropriate
#define  GCP_INCMODE   true        // Incrementally update the matrix
#define  GCP_TRACEL    true        // Only load changed elements to the matrix
#define  GCP_CSTRAY    true        // Include capacitance in device models
#define  GCP_RSTRAY    false       // Include series resistance in device models
#define  GCP_QUITCONV  false       // Quit on convergence failure in TR analysis

#define  GCP_DAMPST    "0x00"      // Damping strategy flags : 0x01 | 0x02 | 0x04 | 0x10 | 0x20 ??? Not implemented correctly

//**************************************************************************************************

class CmdGnuCapOPT : public CmdBase
{
  private :

    bool  bValidate( void ) override;

  public :

    // Options which are floating point values
    wxString  m_osABSTOL;
    wxString  m_osCHGTOL;
    wxString  m_osDAMPMAX;
    wxString  m_osDAMPMIN;
    wxString  m_osDEFL;
    wxString  m_osDEFW;
    wxString  m_osDEFAD;
    wxString  m_osDEFAS;
    wxString  m_osDTMIN;
    wxString  m_osDTRATIO;
    wxString  m_osFLOOR;
    wxString  m_osGMIN;
    wxString  m_osRELTOL;
    wxString  m_osROUND;
    wxString  m_osSHORT;
    wxString  m_osTEMP;
    wxString  m_osTNOM;
    wxString  m_osTRREJECT;
    wxString  m_osTRSTEPG;
    wxString  m_osTRSTEPH;
    wxString  m_osTRSTEPS;
    wxString  m_osTRTOL;
    wxString  m_osVFLOOR;
    wxString  m_osVMAX;
    wxString  m_osVMIN;
    wxString  m_osVNTOL;

    // Options which are integer values
    wxString  m_osDAMPST;
    wxString  m_osHARMS;
    wxString  m_osITL1;
    wxString  m_osITL2;
    wxString  m_osITL3;
    wxString  m_osITL4;
    wxString  m_osITL5;
    wxString  m_osITL6;
    wxString  m_osITL7;
    wxString  m_osITL8;
    wxString  m_osITERMIN;
    wxString  m_osNUMDGT;
    wxString  m_osRECURS;
    wxString  m_osTRANSITS;

    // Options which are string values
    wxString  m_osMETHOD;
    wxString  m_osMODE;
    wxString  m_osORDER;
    wxString  m_osPHASE;

    // Options which are boolean values
    bool      m_bBYPASS;
    bool      m_bCSTRAY;
    bool      m_bFBBYPASS;
    bool      m_bINCMODE;
    bool      m_bLUBYPASS;
    bool      m_bOPTS;
    bool      m_bQUITCONV;
    bool      m_bRSTRAY;
    bool      m_bTRACEL;

          CmdGnuCapOPT( void );
         ~CmdGnuCapOPT( );

    bool  bSetDefaults( void ) override;

    bool  bParse ( void ) override;
    bool  bFormat( void ) override;

    CmdGnuCapOPT & operator = ( const CmdNgSpiceOPT & roCmdOPT );

    void  Print( const wxString & rosPrefix="  " ) override;
};

//**************************************************************************************************

#endif // CMDGCPOPT_HPP
