/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Description;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.PatternChanges;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DescLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "DESC";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String aDesc) {
        if (".CLEAR".equals(aDesc)) {
            context.getObjectContext().removeList(obj, ListKey.DESCRIPTION);
            return ParseResult.SUCCESS;
        }
        if (aDesc.startsWith(".CLEAR.")) {
            context.getObjectContext().removePatternFromList(obj, ListKey.DESCRIPTION, aDesc.substring(7));
            return ParseResult.SUCCESS;
        }
        StringTokenizer tok = new StringTokenizer(aDesc, "|");
        String descString = tok.nextToken();
        if (this.looksLikeAPrerequisite(descString)) {
            return new ParseResult.Fail(this.getTokenName() + " encountered only a PRExxx: " + aDesc, context);
        }
        String ds = EntityEncoder.decode((String)descString);
        if (!StringUtil.hasBalancedParens((String)ds)) {
            return new ParseResult.Fail(this.getTokenName() + " encountered imbalanced Parenthesis: " + aDesc, context);
        }
        ParseResult pr = this.checkForInvalidXMLChars(ds);
        if (!pr.passed()) {
            return pr;
        }
        Description desc = new Description(ds);
        if (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            while (true) {
                if (".CLEAR".equals(token)) {
                    return new ParseResult.Fail(this.getTokenName() + " tag confused by '.CLEAR' as a " + "middle token: " + aDesc, context);
                }
                if (this.looksLikeAPrerequisite(token)) break;
                desc.addVariable(token);
                if (!tok.hasMoreTokens()) {
                    context.getObjectContext().addToList(obj, ListKey.DESCRIPTION, (Object)desc);
                    return ParseResult.SUCCESS;
                }
                token = tok.nextToken();
            }
            while (true) {
                Prerequisite prereq;
                if ((prereq = this.getPrerequisite(token)) == null) {
                    return new ParseResult.Fail("   (Did you put Abilities after the PRExxx tags in " + this.getTokenName() + ":?)", context);
                }
                desc.addPrerequisite(prereq);
                if (!tok.hasMoreTokens()) break;
                token = tok.nextToken();
            }
        }
        context.getObjectContext().addToList(obj, ListKey.DESCRIPTION, (Object)desc);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Collection addedItems;
        PatternChanges changes = context.getObjectContext().getListPatternChanges(obj, ListKey.DESCRIPTION);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        }
        if (removedItems != null && !removedItems.isEmpty()) {
            for (String d : removedItems) {
                list.add(".CLEAR." + d);
            }
        }
        if ((addedItems = changes.getAdded()) != null) {
            for (Description d : addedItems) {
                list.add(d.getPCCText());
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

