/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.load;

import java.math.BigDecimal;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.SizeAdjustment;
import pcgen.core.system.LoadInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;

public class SizemultToken
extends AbstractTokenWithSeparator<LoadInfo>
implements CDOMPrimaryToken<LoadInfo>,
PostDeferredToken<LoadInfo> {
    @Override
    public String getTokenName() {
        return "SIZEMULT";
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, LoadInfo info, String value) {
        int pipeLoc = value.indexOf(124);
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " requires a pipe, found : " + value, context);
        }
        if (pipeLoc != value.lastIndexOf(124)) {
            return new ParseResult.Fail(this.getTokenName() + " requires only one pipe, found : " + value, context);
        }
        String sizeName = value.substring(0, pipeLoc);
        String multiplierString = value.substring(pipeLoc + 1);
        CDOMSingleRef<SizeAdjustment> size = context.getReferenceContext().getCDOMReference(SizeAdjustment.class, sizeName);
        try {
            BigDecimal multiplier = new BigDecimal(multiplierString);
            if (multiplier.compareTo(BigDecimal.ZERO) <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " requires a positive multiplier : " + multiplierString + " in value: " + value, context);
            }
            info.addSizeAdjustment(size, multiplier);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " misunderstood multiplier : " + multiplierString + " in value: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    public String[] unparse(LoadContext context, LoadInfo info) {
        return null;
    }

    @Override
    public Class<LoadInfo> getTokenClass() {
        return LoadInfo.class;
    }

    @Override
    public Class<LoadInfo> getDeferredTokenClass() {
        return LoadInfo.class;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean process(LoadContext context, LoadInfo info) {
        info.resolveSizeAdjustmentMap();
        return true;
    }
}

