/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.load;

import java.math.BigDecimal;
import pcgen.core.system.LoadInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class LoadToken
extends AbstractTokenWithSeparator<LoadInfo>
implements CDOMPrimaryToken<LoadInfo> {
    @Override
    public String getTokenName() {
        return "LOAD";
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, LoadInfo info, String value) {
        int strength;
        int pipeLoc = value.indexOf(124);
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " requires a pipe, found : " + value, context);
        }
        if (pipeLoc != value.lastIndexOf(124)) {
            return new ParseResult.Fail(this.getTokenName() + " requires only one pipe, found : " + value, context);
        }
        String strengthString = value.substring(0, pipeLoc);
        try {
            strength = Integer.parseInt(strengthString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an Integer strength value : " + strengthString + " in value: " + value, context);
        }
        String loadString = value.substring(pipeLoc + 1);
        try {
            BigDecimal load = new BigDecimal(loadString);
            if (load.compareTo(BigDecimal.ZERO) < 0) {
                return new ParseResult.Fail(this.getTokenName() + " requires a non-negative load value, found : " + loadString, context);
            }
            info.addLoadScoreValue(strength, load);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " misunderstood load value : " + loadString + " in value: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    public String[] unparse(LoadContext context, LoadInfo info) {
        return null;
    }

    @Override
    public Class<LoadInfo> getTokenClass() {
        return LoadInfo.class;
    }
}

