/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCAlignment;
import pcgen.core.kit.KitAlignment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AlignToken
extends AbstractTokenWithSeparator<KitAlignment>
implements CDOMPrimaryToken<KitAlignment> {
    private static final Class<PCAlignment> ALIGNMENT_CLASS = PCAlignment.class;

    @Override
    public String getTokenName() {
        return "ALIGN";
    }

    @Override
    public Class<KitAlignment> getTokenClass() {
        return KitAlignment.class;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, KitAlignment kitAlignment, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            CDOMSingleRef<PCAlignment> ref = context.getReferenceContext().getCDOMReference(ALIGNMENT_CLASS, tokText);
            kitAlignment.addAlignment(ref);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitAlignment kitAlignment) {
        List<CDOMSingleRef<PCAlignment>> alignments = kitAlignment.getAlignments();
        if (alignments == null) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(alignments, "|")};
    }
}

