/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deprecated;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedChooseInformation;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.choiceset.CollectionToChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class ChooseFeatToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
Chooser<Ability> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, ReferenceManufacturer<Ability> rm, CDOMObject obj, String value) {
        String title;
        String activeValue;
        int pipeLoc = value.lastIndexOf(124);
        if (pipeLoc == -1) {
            activeValue = value;
            title = this.getDefaultTitle();
        } else {
            String titleString = value.substring(pipeLoc + 1);
            if (titleString.startsWith("TITLE=")) {
                title = titleString.substring(6);
                if (title.startsWith("\"")) {
                    title = title.substring(1, title.length() - 1);
                }
                activeValue = value.substring(0, pipeLoc);
                if (title == null || title.length() == 0) {
                    return new ParseResult.Fail(this.getParentToken() + ":" + this.getTokenName() + " had TITLE= but no title: " + value, context);
                }
            } else {
                activeValue = value;
                title = this.getDefaultTitle();
            }
        }
        PrimitiveCollection<Ability> coll = context.getChoiceSet(rm, activeValue);
        if (coll == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        if (!coll.getGroupingState().isValid()) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Invalid combination of objects was used in: " + activeValue);
            cpr.addErrorMessage("  Check that ALL is not combined");
            cpr.addErrorMessage("  Check that a key is not joined with AND (,)");
            return cpr;
        }
        CollectionToChoiceSet<Ability> pcs = new CollectionToChoiceSet<Ability>(coll);
        CategorizedChooseInformation<Ability> tc = new CategorizedChooseInformation<Ability>("ABILITY", CDOMDirectSingleRef.getRef(AbilityCategory.FEAT), pcs, Ability.class);
        tc.setTitle(title);
        tc.setChoiceActor(this);
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, tc);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        return null;
    }

    @Override
    public void applyChoice(ChooseDriver owner, Ability st, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, st);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, Ability choice) {
        pc.removeAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.removeChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, Ability choice) {
        pc.addAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.applyChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public List<Ability> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList(owner, this.getListKey());
    }

    @Override
    public boolean allow(Ability choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public String getTokenName() {
        return "FEAT";
    }

    @Override
    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        return this.parseTokenWithSeparator(context, context.getReferenceContext().getManufacturer(ABILITY_CLASS, AbilityCategory.FEAT), obj, value);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    protected String getDefaultTitle() {
        return "Ability choice";
    }

    protected AssociationListKey<Ability> getListKey() {
        return AssociationListKey.getKeyFor(ABILITY_CLASS, "CHOOSE*FEAT");
    }

    @Override
    public Ability decodeChoice(LoadContext context, String s) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, s);
    }

    @Override
    public String encodeChoice(Ability choice) {
        return choice.getKeyName();
    }
}

