/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SkillToken;
import pcgen.util.Logging;

public class SkillLevelToken
extends SkillToken {
    public static final String TOKEN_NAME = "SKILLLEVEL";

    @Override
    public String getTokenName() {
        return TOKEN_NAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        CharacterDisplay display = pc.getDisplay();
        SkillToken.SkillDetails details = SkillLevelToken.buildSkillDetails(tokenSource);
        if (details.getPropertyCount() > 0 && "TOTAL".equals(details.getProperty(0))) {
            try {
                int aLevelOffset = Integer.parseInt(details.getSkillId()) - 1;
                if (aLevelOffset >= display.getLevelInfoSize() || aLevelOffset < 0) {
                    return "0";
                }
                PCLevelInfo wLevelInfo = display.getLevelInfo(aLevelOffset);
                int wOutput = wLevelInfo.getSkillPointsGained(pc);
                return Integer.toString(wOutput);
            }
            catch (NumberFormatException nfe) {
                Logging.errorPrint("Error replacing SKILLLEVEL." + tokenSource, nfe);
                return "";
            }
        }
        return "";
    }
}

