/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.chooser;

import java.util.Stack;
import pcgen.facade.core.UIDelegate;
import pcgen.util.chooser.ChoiceHandler;

public final class ChooserFactory {
    private static UIDelegate delegate;
    private static final Stack<String> interfaceClassNameStack;

    private ChooserFactory() {
    }

    public static ChoiceHandler getChoiceHandler() {
        if (interfaceClassNameStack.isEmpty()) {
            return null;
        }
        String className = interfaceClassNameStack.peek();
        try {
            Class<?> c = Class.forName(className);
            ChoiceHandler ci = (ChoiceHandler)c.newInstance();
            return ci;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void pushChooserClassname(String chooserClassname) {
        interfaceClassNameStack.push(chooserClassname);
    }

    public static String popChooserClassname() {
        if (interfaceClassNameStack.isEmpty()) {
            return null;
        }
        return interfaceClassNameStack.pop();
    }

    public static UIDelegate getDelegate() {
        return delegate;
    }

    public static void setDelegate(UIDelegate delegate) {
        ChooserFactory.delegate = delegate;
    }

    static {
        interfaceClassNameStack = new Stack();
    }
}

