/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.util.ArrayList;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.primitive.CompoundAndPrimitive;
import pcgen.cdom.primitive.CompoundOrPrimitive;
import pcgen.cdom.primitive.NegatingPrimitive;
import pcgen.cdom.primitive.ObjectContainerPrimitive;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.PrimitiveToken;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public final class ChoiceSetLoadUtilities {
    private static final String FOUND_ERR_IN_QUAL_CHOICE = "Found error in Qualifier Choice: ";
    private static final String FOUND_ERR_IN_PRIM_CHOICE = "Found error in Primitive Choice: ";

    private ChoiceSetLoadUtilities() {
    }

    public static <T extends CDOMObject> PrimitiveCollection<T> getChoiceSet(LoadContext context, SelectionCreator<T> sc, String joinedOr) {
        ArrayList orList = new ArrayList();
        ParsingSeparator pipe = new ParsingSeparator(joinedOr, '|');
        while (pipe.hasNext()) {
            String joinedAnd = pipe.next();
            if (ChoiceSetLoadUtilities.hasIllegalSeparator(',', joinedAnd)) {
                return null;
            }
            ArrayList andList = new ArrayList();
            ParsingSeparator comma = new ParsingSeparator(joinedAnd, ',');
            while (comma.hasNext()) {
                String primitive = comma.next();
                if (primitive == null || primitive.length() == 0) {
                    Logging.addParseMessage(Logging.LST_ERROR, "Choice argument was null or empty: " + primitive);
                    return null;
                }
                QualifierToken<T> qual = ChoiceSetLoadUtilities.getQualifier(context, sc, primitive);
                if (qual == null) {
                    PrimitiveCollection<T> pcf = ChoiceSetLoadUtilities.getSimplePrimitive(context, sc, primitive);
                    if (pcf == null) {
                        Logging.addParseMessage(Logging.LST_ERROR, "Choice argument was not valid: " + primitive);
                        return null;
                    }
                    andList.add(pcf);
                    continue;
                }
                andList.add(qual);
            }
            if (andList.isEmpty()) continue;
            if (andList.size() == 1) {
                orList.add(andList.get(0));
                continue;
            }
            orList.add(new CompoundAndPrimitive(andList));
        }
        if (orList.isEmpty()) {
            return null;
        }
        if (orList.size() == 1) {
            return (PrimitiveCollection)orList.get(0);
        }
        return new CompoundOrPrimitive(orList);
    }

    protected static boolean hasIllegalSeparator(char separator, String value) {
        if (value.charAt(0) == separator) {
            Logging.addParseMessage(Logging.LST_ERROR, "Choice arguments may not start with " + separator + " : " + value);
            return true;
        }
        if (value.charAt(value.length() - 1) == separator) {
            Logging.addParseMessage(Logging.LST_ERROR, "Choice arguments may not end with " + separator + " : " + value);
            return true;
        }
        if (value.indexOf(String.valueOf(new char[]{separator, separator})) != -1) {
            Logging.addParseMessage(Logging.LST_ERROR, "Choice arguments uses double separator " + separator + separator + " : " + value);
            return true;
        }
        return false;
    }

    public static <T extends CDOMObject> PrimitiveCollection<T> getPrimitive(LoadContext context, SelectionCreator<T> sc, String joinedOr) {
        if (joinedOr.length() == 0 || ChoiceSetLoadUtilities.hasIllegalSeparator('|', joinedOr)) {
            return null;
        }
        ArrayList pcfOrList = new ArrayList();
        ParsingSeparator pipe = new ParsingSeparator(joinedOr, '|');
        while (pipe.hasNext()) {
            String joinedAnd = pipe.next();
            if (joinedAnd.length() == 0 || ChoiceSetLoadUtilities.hasIllegalSeparator(',', joinedAnd)) {
                return null;
            }
            ArrayList pcfAndList = new ArrayList();
            ParsingSeparator comma = new ParsingSeparator(joinedAnd, ',');
            while (comma.hasNext()) {
                String primitive = comma.next();
                if (primitive == null || primitive.length() == 0) {
                    Logging.addParseMessage(Logging.LST_ERROR, "Choice argument was null or empty: " + primitive);
                    return null;
                }
                PrimitiveCollection<T> pcf = ChoiceSetLoadUtilities.getSimplePrimitive(context, sc, primitive);
                if (pcf == null) {
                    Logging.addParseMessage(Logging.LST_ERROR, "Choice argument was not valid: " + primitive);
                    return null;
                }
                pcfAndList.add(pcf);
            }
            if (pcfAndList.size() == 1) {
                pcfOrList.add(pcfAndList.get(0));
                continue;
            }
            pcfOrList.add(new CompoundAndPrimitive(pcfAndList));
        }
        if (pcfOrList.size() == 1) {
            return (PrimitiveCollection)pcfOrList.get(0);
        }
        return new CompoundOrPrimitive(pcfOrList);
    }

    public static PrimitiveInfo getPrimitiveInfo(String key) {
        int openBracketLoc = key.indexOf(91);
        int closeBracketLoc = key.indexOf(93);
        int equalLoc = key.indexOf(61);
        PrimitiveInfo pi = new PrimitiveInfo();
        pi.key = key;
        if (openBracketLoc == -1) {
            if (closeBracketLoc != -1) {
                Logging.errorPrint(FOUND_ERR_IN_PRIM_CHOICE + key + " has a close bracket but no open bracket");
                return null;
            }
            if (equalLoc == -1) {
                pi.tokKey = key;
                pi.tokValue = null;
            } else {
                pi.tokKey = key.substring(0, equalLoc);
                pi.tokValue = key.substring(equalLoc + 1);
                if (pi.tokValue.length() == 0) {
                    Logging.errorPrint(FOUND_ERR_IN_PRIM_CHOICE + key + " has equals but no target value");
                    return null;
                }
            }
            pi.tokRestriction = null;
        } else {
            if (closeBracketLoc == -1) {
                Logging.errorPrint(FOUND_ERR_IN_PRIM_CHOICE + key + " has an open bracket but no close bracket");
                return null;
            }
            if (closeBracketLoc != key.length() - 1) {
                Logging.errorPrint(FOUND_ERR_IN_PRIM_CHOICE + key + " had close bracket, but had characters " + "following the close bracket");
                return null;
            }
            if (equalLoc == -1 || equalLoc > openBracketLoc) {
                pi.tokKey = key.substring(0, openBracketLoc);
                pi.tokValue = null;
                pi.tokRestriction = key.substring(openBracketLoc + 1, closeBracketLoc);
            } else {
                pi.tokKey = key.substring(0, equalLoc);
                pi.tokValue = key.substring(equalLoc + 1, openBracketLoc);
                pi.tokRestriction = key.substring(openBracketLoc + 1, closeBracketLoc);
            }
        }
        return pi;
    }

    public static <T extends Loadable> PrimitiveCollection<T> getSimplePrimitive(LoadContext context, SelectionCreator<T> sc, String key) {
        PrimitiveInfo pi = ChoiceSetLoadUtilities.getPrimitiveInfo(key);
        if (pi == null) {
            return null;
        }
        Class<T> refClass = sc.getReferenceClass();
        PrimitiveCollection<T> prim = ChoiceSetLoadUtilities.getTokenPrimitive(context, refClass, pi);
        if (prim == null) {
            prim = ChoiceSetLoadUtilities.getDynamicGroup(context, pi, refClass);
        }
        if (prim == null) {
            return ChoiceSetLoadUtilities.getTraditionalPrimitive(sc, pi);
        }
        return prim;
    }

    private static <T extends Loadable> PrimitiveCollection<T> getDynamicGroup(LoadContext context, PrimitiveInfo pi, Class<T> refClass) {
        GroupDefinition<T> fgd = context.getGroup(refClass, pi.tokKey);
        if (fgd == null) {
            return null;
        }
        ObjectContainer<T> p = fgd.getPrimitive(context, pi.tokValue);
        return new ObjectContainerPrimitive<T>(p);
    }

    public static <T> PrimitiveCollection<T> getTokenPrimitive(LoadContext context, Class<T> cl, PrimitiveInfo pi) {
        PrimitiveToken<T> prim = TokenLibrary.getPrimitive(cl, pi.tokKey);
        if (prim != null && !prim.initialize(context, cl, pi.tokValue, pi.tokRestriction)) {
            return null;
        }
        return prim;
    }

    public static <T extends Loadable> PrimitiveCollection<T> getTraditionalPrimitive(SelectionCreator<T> sc, PrimitiveInfo pi) {
        String tokKey = pi.tokKey;
        if (pi.tokRestriction != null) {
            Logging.errorPrint("Didn't expect tokRestriction on " + tokKey + " here: " + pi.tokRestriction);
            return null;
        }
        String tokValue = pi.tokValue;
        if ("TYPE".equals(tokKey)) {
            return TokenUtilities.getTypeReference(sc, tokValue);
        }
        if ("!TYPE".equals(tokKey)) {
            CDOMGroupRef<T> typeReference = TokenUtilities.getTypeReference(sc, tokValue);
            if (typeReference == null) {
                return null;
            }
            return new NegatingPrimitive<T>(typeReference, sc.getAllReference());
        }
        if (tokValue != null) {
            Logging.errorPrint("Didn't expect Arguments here: " + tokValue + " was found in " + pi.key);
        }
        if ("ALL".equals(tokKey)) {
            return sc.getAllReference();
        }
        String key = pi.key;
        if (key.startsWith("TYPE.")) {
            return TokenUtilities.getTypeReference(sc, key.substring(5));
        }
        if (key.startsWith("!TYPE.")) {
            return new NegatingPrimitive<T>(TokenUtilities.getTypeReference(sc, key.substring(6)), sc.getAllReference());
        }
        if (key.indexOf(37) == -1) {
            return sc.getReference(key);
        }
        return new PatternMatchingReference<T>(sc.getReferenceClass(), sc.getAllReference(), key);
    }

    public static <T extends CDOMObject> QualifierToken<T> getQualifier(LoadContext loadContext, SelectionCreator<T> sc, String key) {
        String tokRestriction;
        String tokValue;
        String tokKey;
        boolean startsNot;
        if (key == null || key.length() == 0) {
            Logging.errorPrint("Found error in Primitive Choice: item was null or empty");
            return null;
        }
        int openBracketLoc = key.indexOf(91);
        int closeBracketLoc = key.indexOf(93);
        int equalLoc = key.indexOf(61);
        boolean bl = startsNot = key.charAt(0) == '!';
        if (openBracketLoc == -1) {
            if (closeBracketLoc != -1) {
                Logging.errorPrint(FOUND_ERR_IN_QUAL_CHOICE + key + " has a close bracket but no open bracket");
                return null;
            }
            if (equalLoc == -1) {
                tokKey = key;
                tokValue = null;
            } else {
                tokKey = key.substring(0, equalLoc);
                tokValue = key.substring(equalLoc + 1);
            }
            tokRestriction = null;
        } else {
            if (closeBracketLoc == -1) {
                Logging.errorPrint(FOUND_ERR_IN_QUAL_CHOICE + key + " has an open bracket but no close bracket");
                return null;
            }
            if (closeBracketLoc != key.length() - 1) {
                Logging.errorPrint(FOUND_ERR_IN_QUAL_CHOICE + key + " had close bracket, but had characters " + "following the close bracket");
                return null;
            }
            if (closeBracketLoc - openBracketLoc == 1) {
                Logging.errorPrint(FOUND_ERR_IN_QUAL_CHOICE + key + " has an open bracket " + "immediately followed by close bracket");
                return null;
            }
            if (equalLoc == -1 || equalLoc > openBracketLoc) {
                tokKey = key.substring(0, openBracketLoc);
                tokValue = null;
            } else {
                tokKey = key.substring(0, equalLoc);
                tokValue = key.substring(equalLoc + 1, openBracketLoc);
            }
            tokRestriction = key.substring(openBracketLoc + 1, closeBracketLoc);
        }
        if (startsNot) {
            tokKey = tokKey.substring(1);
        }
        TokenLibrary.QualifierTokenIterator it = new TokenLibrary.QualifierTokenIterator(sc.getReferenceClass(), tokKey);
        while (it.hasNext()) {
            QualifierToken token = (QualifierToken)it.next();
            if (token.initialize(loadContext, sc, tokValue, tokRestriction, startsNot)) {
                return token;
            }
            Logging.addParseMessage(Logging.LST_ERROR, "Failed in parsing typeStr: " + key);
        }
        return null;
    }

    public static class PrimitiveInfo {
        public String key;
        public String tokKey;
        public String tokValue;
        public String tokRestriction;
    }
}

