/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedEvent;
import pcgen.cdom.reference.UnconstructedListener;
import pcgen.rules.context.RuntimeReferenceContext;
import pcgen.rules.context.TrackingManufacturer;
import pcgen.util.Logging;

public class TrackingReferenceContext
extends RuntimeReferenceContext
implements UnconstructedListener {
    private final DoubleKeyMapToList<CDOMReference<?>, URI, String> track = new DoubleKeyMapToList(WeakHashMap.class, HashMap.class);
    private final Set<ReferenceManufacturer<?>> listening = new HashSet();

    @Override
    public <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> cl, Category<T> cat) {
        ReferenceManufacturer<T> mfg = super.getManufacturer(cl, cat);
        if (mfg instanceof TrackingManufacturer) {
            return mfg;
        }
        if (!this.listening.contains(mfg)) {
            mfg.addUnconstructedListener(this);
            this.listening.add(mfg);
        }
        return new TrackingManufacturer<T>(this, mfg);
    }

    @Override
    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(Class<T> cl) {
        ReferenceManufacturer<T> mfg = super.getManufacturer(cl);
        if (mfg instanceof TrackingManufacturer) {
            return mfg;
        }
        if (!this.listening.contains(mfg)) {
            mfg.addUnconstructedListener(this);
            this.listening.add(mfg);
        }
        return new TrackingManufacturer<T>(this, mfg);
    }

    @Override
    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(ManufacturableFactory<T> factory) {
        ReferenceManufacturer<T> mfg = super.getManufacturer(factory);
        if (mfg instanceof TrackingManufacturer) {
            return mfg;
        }
        if (!this.listening.contains(mfg)) {
            mfg.addUnconstructedListener(this);
            this.listening.add(mfg);
        }
        return new TrackingManufacturer<T>(this, mfg);
    }

    @Override
    public void unconstructedReferenceFound(UnconstructedEvent e) {
        CDOMReference<?> ref = e.getReference();
        Set uris = this.track.getSecondaryKeySet(ref);
        if (uris == null) {
            return;
        }
        for (URI uri : uris) {
            List tokens = this.track.getListFor(ref, (Object)uri);
            TreeSet<String> tokenNames = new TreeSet<String>();
            for (String tok : tokens) {
                if (tok == null) continue;
                tokenNames.add(tok);
            }
            Logging.errorPrint("  Was used in " + uri + " in tokens: " + tokenNames);
        }
    }

    private String getSource() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String source = null;
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (!className.startsWith("plugin.lsttokens")) continue;
            source = className;
            break;
        }
        return source;
    }

    <T> void trackReference(CDOMReference<T> ref) {
        String src = this.getSource();
        if (src == null) {
            src = "?";
        }
        this.track.addToListFor(ref, (Object)this.getSourceURI(), (Object)src);
    }
}

