/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.equip;

import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.gui2.filter.FilteredListFacadeTableModel;

public class EquipmentTableModel
extends FilteredListFacadeTableModel<EquipmentFacade>
implements EquipmentListFacade.EquipmentListListener {
    protected EquipmentListFacade equipmentList = null;
    protected EquipmentSetFacade equipmentSet = null;

    public EquipmentTableModel(CharacterFacade character) {
        super(character);
    }

    protected void setEquipmentList(EquipmentListFacade equipmentList) {
        EquipmentListFacade oldList = this.equipmentList;
        if (oldList != null) {
            oldList.removeEquipmentListListener(this);
        }
        this.equipmentList = equipmentList;
        if (equipmentList != null) {
            equipmentList.addEquipmentListListener(this);
        }
        super.setDelegate(equipmentList);
    }

    protected void setEquipmentSet(EquipmentSetFacade equipmentSet) {
        this.equipmentSet = equipmentSet;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Object.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public void quantityChanged(EquipmentListFacade.EquipmentListEvent e) {
        for (int i = 0; i < this.sortedList.getSize(); ++i) {
            if (e.getEquipment() != this.sortedList.getElementAt(i)) continue;
            this.fireTableCellUpdated(i, 3);
            return;
        }
    }

    public EquipmentFacade getValue(int index) {
        return (EquipmentFacade)this.sortedList.getElementAt(index);
    }

    @Override
    protected Object getValueAt(EquipmentFacade equipment, int column) {
        switch (column) {
            case 0: {
                return equipment;
            }
            case 1: {
                return equipment.getTypes()[0];
            }
            case 2: {
                return this.equipmentSet.getLocation(equipment);
            }
            case 3: {
                return this.equipmentList.getQuantity(equipment);
            }
            case 4: {
                return Float.valueOf(this.character.getInfoFactory().getWeight(equipment));
            }
            case 5: {
                return this.character.getInfoFactory().getDescription(equipment);
            }
        }
        return null;
    }

    @Override
    public void elementModified(ListEvent<EquipmentFacade> e) {
    }
}

