/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import pcgen.cdom.enumeration.EquipmentLocation;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.system.LanguageBundle;

public abstract class PreEquippedTester
extends AbstractPrerequisiteTest {
    public int passesPreEquipHandleTokens(Prerequisite prereq, PlayerCharacter character, EquipmentLocation equippedType) throws PrerequisiteException {
        int runningTotal;
        PrerequisiteOperator operator;
        boolean isEquipped = false;
        if (character.hasEquipment()) {
            String aString = prereq.getKey();
            for (Equipment eq : character.getDisplay().getEquippedEquipmentSet()) {
                String eqName;
                if (eq.getLocation() != equippedType) continue;
                if (aString.startsWith("WIELDCATEGORY=") || aString.startsWith("WIELDCATEGORY.")) {
                    WieldCategory wCat = eq.getEffectiveWieldCategory(character);
                    if (wCat == null || !wCat.getKeyName().equalsIgnoreCase(aString.substring(14))) continue;
                    isEquipped = true;
                    break;
                }
                if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                    isEquipped = eq.isType(aString);
                    break;
                }
                if (aString.startsWith("BASEITEM=")) {
                    eqName = eq.getBaseItemName();
                    aString = aString.substring(aString.indexOf("=") + 1);
                } else {
                    eqName = eq.getName();
                }
                if (aString.indexOf(37) >= 0) {
                    int percentPos = aString.indexOf(37);
                    if (!eqName.regionMatches(true, 0, aString, 0, percentPos)) continue;
                    isEquipped = true;
                    break;
                }
                if (!eqName.equalsIgnoreCase(aString)) continue;
                isEquipped = true;
                break;
            }
        }
        if ((operator = prereq.getOperator()).equals((Object)PrerequisiteOperator.EQ) || operator.equals((Object)PrerequisiteOperator.GTEQ)) {
            runningTotal = isEquipped ? 1 : 0;
        } else if (operator.equals((Object)PrerequisiteOperator.NEQ) || operator.equals((Object)PrerequisiteOperator.LT)) {
            runningTotal = isEquipped ? 0 : 1;
        } else {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreEquipped.error.invalid_comparison", prereq.toString()));
        }
        return this.countedTotal(prereq, runningTotal);
    }
}

