/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.regex.Pattern;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillInfoUtilities;
import pcgen.core.analysis.SkillRankControl;

public final class SkillModifier {
    public static Integer modifier(Skill sk, PlayerCharacter aPC) {
        int bonus = 0;
        if (aPC == null) {
            return 0;
        }
        String keyName = sk.getKeyName();
        CDOMSingleRef<PCStat> statref = sk.get(ObjectKey.KEY_STAT);
        if (statref != null) {
            PCStat stat = statref.resolvesTo();
            bonus = aPC.getStatModFor(stat);
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "STAT." + stat.getKeyName()));
        }
        bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", keyName));
        for (Type singleType : sk.getTrueTypeList(false)) {
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "TYPE." + singleType));
        }
        bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "LIST"));
        bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "ALL"));
        if (aPC.isClassSkill(sk)) {
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CSKILL", keyName));
            for (Type singleType : sk.getTrueTypeList(false)) {
                bonus = (int)((double)bonus + aPC.getTotalBonusTo("CSKILL", "TYPE." + singleType));
            }
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CSKILL", "LIST"));
        }
        if (!aPC.isClassSkill(sk) && !sk.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CCSKILL", keyName));
            for (Type singleType : sk.getTrueTypeList(false)) {
                bonus = (int)((double)bonus + aPC.getTotalBonusTo("CCSKILL", "TYPE." + singleType));
            }
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CCSKILL", "LIST"));
        }
        int aCheckBonus = sk.getSafe(ObjectKey.ARMOR_CHECK).calculateBonus(aPC);
        bonus += aCheckBonus;
        String aString = SettingsHandler.getGame().getRankModFormula();
        if (aString.length() != 0) {
            aString = aString.replaceAll(Pattern.quote("$$RANK$$"), SkillRankControl.getTotalRank(aPC, sk).toString());
            bonus += aPC.getVariableValue(aString, "").intValue();
        }
        return bonus;
    }

    public static int getStatMod(Skill sk, PlayerCharacter pc) {
        CDOMSingleRef<PCStat> stat = sk.get(ObjectKey.KEY_STAT);
        if (stat == null) {
            int statMod = 0;
            if (Globals.getGameModeHasPointPool()) {
                ArrayList<Type> typeList = new ArrayList<Type>();
                SkillInfoUtilities.getKeyStatList(pc, sk, typeList);
                for (int i = 0; i < typeList.size(); ++i) {
                    statMod = (int)((double)statMod + pc.getTotalBonusTo("SKILL", "TYPE." + typeList.get(i)));
                }
            }
            return statMod;
        }
        return pc.getStatModFor(stat.resolvesTo());
    }
}

