/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.List;
import pcgen.cdom.base.DataSetInitializedFacet;
import pcgen.cdom.enumeration.DataSetID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.facet.DataSetInitializationFacet;
import pcgen.cdom.facet.base.AbstractScopeFacet;
import pcgen.core.Ability;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;

public class HiddenTypeFacet
extends AbstractScopeFacet<DataSetID, Class<?>, Type>
implements DataSetInitializedFacet {
    private DataSetInitializationFacet datasetInitializationFacet;

    @Override
    public void initialize(LoadContext context) {
        for (Campaign c : context.getLoadedCampaigns()) {
            this.loadCampaignHiddenTypes(context.getDataSetID(), c);
        }
    }

    private void loadCampaignHiddenTypes(DataSetID id, Campaign c) {
        this.loadHiddenTypes(id, ListKey.HIDDEN_Equipment, Equipment.class, c);
        this.loadHiddenTypes(id, ListKey.HIDDEN_Ability, Ability.class, c);
        this.loadHiddenTypes(id, ListKey.HIDDEN_Skill, Skill.class, c);
        for (Campaign subCamp : c.getSubCampaigns()) {
            this.loadCampaignHiddenTypes(id, subCamp);
        }
    }

    private void loadHiddenTypes(DataSetID id, ListKey<String> listKey, Class<?> cl, Campaign c) {
        List<String> hiddentypes = c.getSafeListFor(listKey);
        for (String s : hiddentypes) {
            this.add(id, cl, Type.getConstant(s), c);
        }
    }

    public void setDataSetInitializationFacet(DataSetInitializationFacet datasetInitializationFacet) {
        this.datasetInitializationFacet = datasetInitializationFacet;
    }

    public void init() {
        this.datasetInitializationFacet.addDataSetInitializedFacet(this);
    }
}

