/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.List;
import pcgen.base.lang.UnreachableError;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.util.enumeration.Load;

public enum SkillArmorCheck {
    NONE{

        @Override
        public int calculateBonus(PlayerCharacter pc) {
            return 0;
        }
    }
    ,
    YES,
    NONPROF{

        @Override
        protected boolean useEquipment(PlayerCharacter pc, Equipment equipment) {
            return !pc.isProficientWith(equipment);
        }

        @Override
        protected int calculateMin(PlayerCharacter pc) {
            return 0;
        }
    }
    ,
    DOUBLE{

        @Override
        protected int getMultiplier() {
            return 2;
        }
    }
    ,
    WEIGHT{

        @Override
        protected int calculateMax(PlayerCharacter pc) {
            return -((int)(pc.getDisplay().totalWeight().doubleValue() / 5.0));
        }
    };


    public int calculateBonus(PlayerCharacter pc) {
        int min = 0;
        int max = 0;
        if (Globals.checkRule("SYS_WTPSK")) {
            min = this.calculateMin(pc);
            max = this.calculateMax(pc);
        }
        return this.getMultiplier() * Math.min(min, max + (int)pc.getTotalBonusTo("MISC", "ACCHECK"));
    }

    protected int getMultiplier() {
        return 1;
    }

    protected int calculateMin(PlayerCharacter pc) {
        int penalty = 0;
        if (Globals.checkRule("SYS_LDPACSK")) {
            Load load = pc.getDisplay().getLoadType();
            switch (load) {
                case LIGHT: {
                    penalty = SettingsHandler.getGame().getLoadInfo().getLoadCheckPenalty("LIGHT");
                    break;
                }
                case MEDIUM: {
                    penalty = SettingsHandler.getGame().getLoadInfo().getLoadCheckPenalty("MEDIUM");
                    break;
                }
                case HEAVY: 
                case OVERLOAD: {
                    penalty = SettingsHandler.getGame().getLoadInfo().getLoadCheckPenalty("HEAVY");
                    break;
                }
                default: {
                    throw new UnreachableError("Internal Error: In Skill.modifier the load " + (Object)((Object)load) + " is not supported.");
                }
            }
        }
        return penalty;
    }

    protected int calculateMax(PlayerCharacter pc) {
        int max = 0;
        List<Equipment> itemList = pc.getEquipmentOfType("Armor", 1);
        for (Equipment eq : pc.getEquipmentOfType("Shield", 1)) {
            if (itemList.contains(eq)) continue;
            itemList.add(eq);
        }
        for (Equipment eq : itemList) {
            if (!this.useEquipment(pc, eq)) continue;
            max += eq.acCheck(pc).intValue();
        }
        return max;
    }

    protected boolean useEquipment(PlayerCharacter pc, Equipment eq) {
        return true;
    }
}

