/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RoleToken
extends AbstractNonEmptyToken<Race>
implements CDOMPrimaryToken<Race> {
    public String getTokenName() {
        return "ROLE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Race race, String value) {
        ParseResult pr = this.checkForIllegalSeparator('.', value);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer aTok = new StringTokenizer(value, ".", false);
        while (aTok.hasMoreTokens()) {
            String role = aTok.nextToken();
            if (SettingsHandler.getGame().getMonsterRoleList().contains(role)) {
                context.getObjectContext().addToList((CDOMObject)race, ListKey.MONSTER_ROLES, (Object)role);
                continue;
            }
            return new ParseResult.Fail(this.getTokenName() + " '" + role + "' is not a known monster role for this game mode.", context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Race race) {
        Collection removed;
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)race, ListKey.MONSTER_ROLES);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collection added = changes.getAdded();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            sb.append(".CLEAR");
        }
        if (added != null && !added.isEmpty()) {
            if (globalClear) {
                sb.append(".");
            }
            sb.append(StringUtil.join((Collection)added, (String)"."));
        }
        if ((removed = changes.getRemoved()) != null && !removed.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append("REMOVE.");
            sb.append(StringUtil.join((Collection)removed, (String)"."));
        }
        if (sb.length() == 0) {
            context.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return new String[]{sb.toString()};
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

