/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.Collections;
import pcgen.base.util.FormatManager;
import pcgen.base.util.ObjectContainer;

public class BasicObjectContainer<T>
implements ObjectContainer<T> {
    private final FormatManager<T> formatManager;
    private final T object;

    public BasicObjectContainer(FormatManager<T> fmtManager, T obj) {
        if (fmtManager == null) {
            throw new IllegalArgumentException("Manager may not be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object may not be null");
        }
        if (!fmtManager.getManagedClass().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Object of class " + obj.getClass() + " is not compatible with provided Format Manager: " + fmtManager.getManagedClass());
        }
        this.object = obj;
        this.formatManager = fmtManager;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.formatManager.unconvert(this.object);
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.formatManager.getManagedClass();
    }

    @Override
    public Collection<? extends T> getContainedObjects() {
        return Collections.singleton(this.object);
    }

    @Override
    public boolean contains(T obj) {
        return obj != null && obj.equals(this.object);
    }
}

