/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.gear;

import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.helper.EqModRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.EquipmentModifier;
import pcgen.core.kit.KitGear;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class EqmodToken
extends AbstractTokenWithSeparator<KitGear>
implements CDOMPrimaryToken<KitGear> {
    private static final Class<EquipmentModifier> EQUIPMENT_MODIFIER_CLASS = EquipmentModifier.class;

    public String getTokenName() {
        return "EQMOD";
    }

    public Class<KitGear> getTokenClass() {
        return KitGear.class;
    }

    protected char separator() {
        return '.';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, KitGear kitGear, String value) {
        StringTokenizer dotTok = new StringTokenizer(value, ".");
        while (dotTok.hasMoreTokens()) {
            String aEqModName = dotTok.nextToken();
            if (aEqModName.equalsIgnoreCase("NONE")) {
                return new ParseResult.Fail("Embedded NONE is prohibited in " + this.getTokenName(), context);
            }
            ParseResult pr = this.checkForIllegalSeparator('|', aEqModName);
            if (!pr.passed()) {
                return pr;
            }
            StringTokenizer pipeTok = new StringTokenizer(aEqModName, "|");
            String eqModKey = pipeTok.nextToken();
            CDOMSingleRef eqMod = context.getReferenceContext().getCDOMReference(EQUIPMENT_MODIFIER_CLASS, eqModKey);
            EqModRef modRef = new EqModRef(eqMod);
            while (pipeTok.hasMoreTokens()) {
                String assocTok = pipeTok.nextToken();
                if (assocTok.indexOf(93) != -1) {
                    if (assocTok.indexOf("[]") != -1) {
                        return new ParseResult.Fail("Found empty assocation in " + this.getTokenName() + ": " + value, context);
                    }
                    StringTokenizer bracketTok = new StringTokenizer(assocTok, "]");
                    while (bracketTok.hasMoreTokens()) {
                        String assoc = bracketTok.nextToken();
                        int openBracketLoc = assoc.indexOf(91);
                        if (openBracketLoc == -1) {
                            return new ParseResult.Fail("Found close bracket without open bracket in assocation in " + this.getTokenName() + ": " + value, context);
                        }
                        if (openBracketLoc == assoc.lastIndexOf(91)) continue;
                        return new ParseResult.Fail("Found open bracket without close bracket in assocation in " + this.getTokenName() + ": " + value, context);
                    }
                }
                modRef.addChoice(assocTok);
            }
            kitGear.addModRef(modRef);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, KitGear kitGear) {
        if (!kitGear.hasEqMods()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (EqModRef modRef : kitGear.getEqMods()) {
            String key = modRef.getRef().getLSTformat(false);
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            for (String s : modRef.getChoices()) {
                sb.append("|").append(s);
            }
            set.add(sb.toString());
        }
        return new String[]{StringUtil.join(set, (String)".")};
    }
}

