/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.LogError;
import com.izforge.izpack.util.LogMessage;
import com.izforge.izpack.util.LogWarning;
import java.io.File;
import java.io.FileWriter;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Log
implements LogError,
LogWarning,
LogMessage {
    private static final String RESOURCE_PREFIX = "log.";
    private static final String DATE_FORMAT = "log.timeStamp";
    private static final String MESSAGE_PREFIX = "log.message_";
    private static final String WARNING_PREFIX = "log.warning_";
    private static final String ERROR_PREFIX = "log.error_";
    private static final String DEBUG_SWITCH = "IzPack.debug";
    private static final String CHANNEL_SPEC = "IzPack.debug.channel";
    private static final String CHANNEL_LIST = "IzPack.debug.dumpList";
    private static Log me = null;
    private String newline = System.getProperty("line.separator");
    private AutomatedInstallData installData = null;
    private ArrayList<Record> messages = new ArrayList();
    private ArrayList<Record> warnings = new ArrayList();
    private ArrayList<Record> errors = new ArrayList();
    private ArrayList<Record> debug = new ArrayList();
    private Vector<String> channels = null;
    private Hashtable<String, String> recordedChannels = null;
    private boolean debugActive = false;
    private boolean dumpChannels = false;

    private Log() {
        this.installData = AutomatedInstallData.getInstance();
        String string = System.getProperty(DEBUG_SWITCH);
        if (string != null && string.toUpperCase().equals("ON")) {
            this.debugActive = true;
        }
        if (this.debugActive) {
            this.recordedChannels = new Hashtable();
            this.channels = new Vector();
            string = System.getProperty(CHANNEL_LIST);
            if (string != null && string.toUpperCase().equals("ON")) {
                this.dumpChannels = true;
            }
            if ((string = System.getProperty(CHANNEL_SPEC)) != null) {
                String[] stringArray = string.split(",");
                this.channels.addAll(Arrays.asList(stringArray));
            }
        }
    }

    public static Log getInstance() {
        if (me == null) {
            me = new Log();
        }
        return me;
    }

    public void addMessage(int n, String[] stringArray) {
        if (n >= 0 && n < 0) {
            this.messages.add(new Record(n, stringArray));
        }
    }

    public void addCustomMessage(String string, String[] stringArray) {
        this.messages.add(new Record(string, stringArray));
    }

    public void addWarning(int n, String[] stringArray, Throwable throwable) {
        if (n >= 1000 && n < 1000) {
            this.warnings.add(new Record(n, stringArray, throwable));
        }
    }

    public void addCustomWarning(String string, String[] stringArray, Throwable throwable) {
        this.warnings.add(new Record(string, stringArray, throwable));
    }

    public void addError(int n, String[] stringArray, Throwable throwable) {
        if (n >= 2000 && n < 2001) {
            this.errors.add(new Record(n, stringArray, throwable));
            this.installData.installSuccess = false;
        }
    }

    public void addCustomError(String string, String[] stringArray, Throwable throwable) {
        this.errors.add(new Record(string, stringArray, throwable));
    }

    public void addDebugMessage(String string, String[] stringArray, String string2, Throwable throwable) {
        if (this.debugActive) {
            this.recordedChannels.put(string2, string2);
            if (string2 == null || string2.length() == 0 || this.channels.contains(string2)) {
                Record record = new Record(string, stringArray, throwable, string2);
                this.debug.add(record);
                System.out.println(this.buildDebug(record));
            }
        }
    }

    public boolean messagesRecorded() {
        return !this.messages.isEmpty();
    }

    public boolean warningsRecorded() {
        return !this.warnings.isEmpty();
    }

    public boolean errorsRecorded() {
        return !this.errors.isEmpty();
    }

    public void informUser() {
        String string = "";
        int n = 2;
        if (this.errorsRecorded()) {
            n = 0;
            string = this.installData.langpack.getString("log.informUserFail");
        } else if (this.warningsRecorded()) {
            n = 2;
            string = this.installData.langpack.getString("log.informUserPartial");
        } else {
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(null, string, this.installData.langpack.getString("log.informUserTitle"), 0, n);
        if (n2 == 0) {
            this.writeReport();
        }
    }

    public void writeReport() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.installData.langpack.getString("log.saveLogTitle"));
        jFileChooser.setSelectedFile(new File(this.installData.langpack.getString("log.LogFileName")));
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            this.writeReport(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void writeReport(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.compileReport();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Throwable throwable) {
            try {
                JOptionPane.showMessageDialog(null, this.installData.langpack.getString("log.reportWriteError", new String[]{string}), this.installData.langpack.getString("log.reportWriteErrorTitle"), 0);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }

    private String compileReport() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.installData.langpack.getString(DATE_FORMAT);
        stringBuffer.append("-------------------------------------------------------------------------------");
        stringBuffer.append(this.newline);
        stringBuffer.append(this.installData.langpack.getString("log.reportHeading"));
        stringBuffer.append(this.newline);
        stringBuffer.append("-------------------------------------------------------------------------------");
        stringBuffer.append(this.newline);
        if (this.errorsRecorded()) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.installFailed"));
            stringBuffer.append(this.newline);
        } else if (this.warningsRecorded()) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.partialInstall"));
            stringBuffer.append(this.newline);
        }
        stringBuffer.append(this.newline);
        stringBuffer.append(this.installData.langpack.getString("log.messageCount", new String[]{Integer.toString(this.messages.size()), Integer.toString(this.warnings.size()), Integer.toString(this.errors.size())}));
        stringBuffer.append(this.newline);
        stringBuffer.append(this.newline);
        stringBuffer.append(this.installData.langpack.getString("log.application", new String[]{this.installData.info.getAppName(), this.installData.info.getAppVersion()}));
        stringBuffer.append(this.newline);
        stringBuffer.append(this.installData.langpack.getString("log.timePrefix", new String[]{new SimpleDateFormat(string, new DateFormatSymbols()).format(new Date())}));
        stringBuffer.append(this.newline);
        stringBuffer.append(this.installData.langpack.getString("log.pathPrefix", new String[]{this.installData.getInstallPath()}));
        stringBuffer.append(this.newline);
        if (this.messagesRecorded()) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.messageHeading"));
            stringBuffer.append(this.newline);
            stringBuffer.append(this.newline);
            n2 = this.messages.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.buildMessage(n));
            }
        }
        if (this.warningsRecorded()) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.warningHeading"));
            stringBuffer.append(this.newline);
            stringBuffer.append(this.newline);
            n2 = this.warnings.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.buildWarning(n));
            }
        }
        if (this.errorsRecorded()) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.errorHeading"));
            stringBuffer.append(this.newline);
            stringBuffer.append(this.newline);
            n2 = this.errors.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.buildError(n));
            }
        }
        if (this.debugActive) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.debugHeading"));
            stringBuffer.append(this.newline);
            stringBuffer.append(this.newline);
            n2 = this.errors.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.buildDebug(n));
            }
        }
        stringBuffer.append("-------------------------------------------------------------------------------");
        stringBuffer.append(this.newline);
        return stringBuffer.toString();
    }

    private String buildMessage(int n) {
        Record record = this.messages.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.installData.langpack.getString("log.messagePrefix", new String[]{Integer.toString(n)}));
        if (record.message >= 0) {
            stringBuffer.append(this.installData.langpack.getString(MESSAGE_PREFIX + Integer.toString(record.message), record.variables));
        } else {
            stringBuffer.append(MessageFormat.format(record.template, record.variables));
        }
        stringBuffer.append(this.newline);
        return stringBuffer.toString();
    }

    private String buildWarning(int n) {
        Record record = this.warnings.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.installData.langpack.getString("log.warningPrefix", new String[]{Integer.toString(n)}));
        if (record.message >= 0) {
            stringBuffer.append(this.installData.langpack.getString(WARNING_PREFIX + Integer.toString(record.message - 1000), record.variables));
        } else {
            stringBuffer.append(MessageFormat.format(record.template, record.variables));
        }
        if (record.exception != null) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.exceptionPrefix", new String[]{record.exception.toString()}));
        }
        stringBuffer.append(this.newline);
        return stringBuffer.toString();
    }

    private String buildError(int n) {
        Record record = this.errors.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.installData.langpack.getString("log.errorPrefix", new String[]{Integer.toString(n)}));
        if (record.message >= 0) {
            stringBuffer.append(this.installData.langpack.getString(ERROR_PREFIX + Integer.toString(record.message - 2000), record.variables));
        } else {
            stringBuffer.append(MessageFormat.format(record.template, record.variables));
        }
        if (record.exception != null) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.exceptionPrefix", new String[]{record.exception.toString()}));
        }
        stringBuffer.append(this.newline);
        return stringBuffer.toString();
    }

    private String buildDebug(int n) {
        Record record = this.debug.get(n);
        return this.buildDebug(record);
    }

    private String buildDebug(Record record) {
        StringBuffer stringBuffer = new StringBuffer();
        if (record.channel == null || record.channel.length() == 0) {
            stringBuffer.append("Debug - general: ");
        } else {
            stringBuffer.append("Debug - ").append(record.channel).append(": ");
        }
        stringBuffer.append(MessageFormat.format(record.template, record.variables));
        if (record.exception != null) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.installData.langpack.getString("log.exceptionPrefix", new String[]{record.exception.toString()}));
        }
        stringBuffer.append(this.newline);
        return stringBuffer.toString();
    }

    public void dumpRecordedChannels() {
        if (this.debugActive && this.dumpChannels) {
            System.out.println();
            System.out.println("The following debug channels did record messages:");
            System.out.println();
            Enumeration<String> enumeration = this.recordedChannels.keys();
            while (enumeration.hasMoreElements()) {
                System.out.println(" - " + enumeration.nextElement().toString());
            }
            System.out.println();
        }
    }

    private class Record {
        String channel;
        String template;
        int message;
        String[] variables;
        Throwable exception;

        Record(int n, String[] stringArray) {
            this.message = n;
            this.variables = stringArray;
        }

        Record(String string, String[] stringArray) {
            this.message = -1;
            this.template = string;
            this.variables = stringArray;
        }

        Record(int n, String[] stringArray, Throwable throwable) {
            this.message = n;
            this.variables = stringArray;
            this.exception = throwable;
        }

        Record(String string, String[] stringArray, Throwable throwable) {
            this.message = -1;
            this.template = string;
            this.variables = stringArray;
            this.exception = throwable;
        }

        Record(String string, String[] stringArray, Throwable throwable, String string2) {
            this.message = -1;
            this.template = string;
            this.variables = stringArray;
            this.exception = throwable;
            this.channel = string2;
        }
    }
}

