/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.chart.AbstractChartModel;
import com.jgoodies.chart.AbstractTreeChartModel;
import com.jgoodies.chart.ChartModel;
import com.jgoodies.chart.ColoredChartModel;
import com.jgoodies.chart.FilteredChartModel;
import com.jgoodies.chart.TreeChartModel;
import com.jgoodies.framework.builder.PopupMenuBuilder;
import com.jgoodies.jdiskreport.gui.application.JDApplicationModel;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.jdiskreport.gui.node.AbstractNode;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.settings.ChartSettings;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import com.jgoodies.jdiskreport.gui.statistic.Statistics;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public final class JDPresentationModel {
    private static final ResourceMap RESOURCES = Application.getResourceMap(JDPresentationModel.class);
    private final JDResultModel resultModel;
    private final DelegatingTreeChartModel<AbstractNode> treeChartModel;
    private final DelegatingTableModel sizeTableModel;
    private final ChartModel<AbstractNode> sizeChartModel;
    private final FilteredChartModel<AbstractNode> filteredSizeChartModel;
    private final ColoredChartModel<AbstractNode> coloredSizeChartModel;
    private final DelegatingTableModel largestFilesTableModel;
    private final ListSelectionModel largestFilesSelectionModel;
    private final DelegatingTableModel leastRecentlyModifiedFilesTableModel;
    private final DelegatingTableModel mostRecentlyModifiedFilesTableModel;
    private final DelegatingTableModel leastRecentlyAccessedFilesTableModel;
    private final DelegatingTableModel mostRecentlyAccessedFilesTableModel;
    private final DelegatingTableModel leastRecentlyUsedFilesTableModel;
    private final DelegatingTableModel mostRecentlyUsedFilesTableModel;
    private final DelegatingTableModel sizeDistributionTableModel;
    private final ChartModel<Object> sizeDistributionChartModel;
    private final ColoredChartModel<Object> coloredSizeDistributionChartModel;
    private final DelegatingTableModel modifiedDistributionTableModel;
    private final ChartModel<Object> modifiedDistributionChartModel;
    private final ColoredChartModel<Object> coloredModifiedDistributionChartModel;
    private final DelegatingTableModel accessedDistributionTableModel;
    private final ChartModel<Object> accessedDistributionChartModel;
    private final ColoredChartModel<Object> coloredAccessedDistributionChartModel;
    private final DelegatingTableModel typeDistributionTableModel;
    private final ChartModel<Object> typeDistributionChartModel;
    private final FilteredChartModel<Object> filteredTypeDistributionChartModel;
    private final ColoredChartModel<Object> coloredTypeDistributionChartModel;

    JDPresentationModel(JDResultModel resultModel) {
        this.resultModel = resultModel;
        this.treeChartModel = new DelegatingTreeChartModel<AbstractNode>(this.getTreeChartModel(resultModel.getRootNode()));
        String collapsedText = RESOURCES.getString("PresentationModel.filter.collapsedText", new Object[0]);
        Color collapsedColor = RESOURCES.getColor("PresentationModel.filter.collapsedColor");
        ChartSettings chartSettings = resultModel.getGuiSettings().chartSettings();
        int itemLimit = chartSettings.getElementLimit();
        float itemThreshold = chartSettings.getElementThreshold();
        float saturation = chartSettings.getSaturation();
        float brightness = chartSettings.getBrightness();
        this.sizeTableModel = new DelegatingTableModel(this.getSizeTableModel(resultModel.getRootNode()));
        this.sizeChartModel = new SizeChartModel(this.sizeTableModel, resultModel.getGuiSettings());
        this.filteredSizeChartModel = new FilteredChartModel<AbstractNode>(this.sizeChartModel, itemLimit, itemThreshold, collapsedText, collapsedColor);
        this.coloredSizeChartModel = new ColoredChartModel<AbstractNode>(this.filteredSizeChartModel, itemLimit, saturation, brightness);
        Statistics rootStatistics = resultModel.getRootNode().getStatistics();
        this.largestFilesTableModel = new DelegatingTableModel(rootStatistics.getLargestFiles().getTableModel());
        this.largestFilesSelectionModel = new DefaultListSelectionModel();
        this.largestFilesSelectionModel.setSelectionMode(0);
        this.leastRecentlyModifiedFilesTableModel = new DelegatingTableModel(rootStatistics.getLeastRecentlyModifiedFiles().getTableModel());
        this.mostRecentlyModifiedFilesTableModel = new DelegatingTableModel(rootStatistics.getMostRecentlyModifiedFiles().getTableModel());
        this.leastRecentlyAccessedFilesTableModel = new DelegatingTableModel(rootStatistics.getLeastRecentlyAccessedFiles().getTableModel());
        this.mostRecentlyAccessedFilesTableModel = new DelegatingTableModel(rootStatistics.getMostRecentlyUsedFiles().getTableModel());
        this.leastRecentlyUsedFilesTableModel = new DelegatingTableModel(rootStatistics.getLeastRecentlyAccessedFiles().getTableModel());
        this.mostRecentlyUsedFilesTableModel = new DelegatingTableModel(rootStatistics.getMostRecentlyUsedFiles().getTableModel());
        this.sizeDistributionTableModel = new DelegatingTableModel(rootStatistics.getSizeDistribution().getTableModel());
        this.sizeDistributionChartModel = new DistributionChartModel(this.sizeDistributionTableModel, resultModel.getGuiSettings());
        this.coloredSizeDistributionChartModel = new ColoredChartModel<Object>(this.sizeDistributionChartModel, itemLimit, saturation, brightness);
        this.modifiedDistributionTableModel = new DelegatingTableModel(rootStatistics.getModifiedDistribution().getTableModel());
        this.modifiedDistributionChartModel = new DistributionChartModel(this.modifiedDistributionTableModel, resultModel.getGuiSettings());
        this.coloredModifiedDistributionChartModel = new ColoredChartModel<Object>(this.modifiedDistributionChartModel, itemLimit, saturation, brightness);
        this.accessedDistributionTableModel = new DelegatingTableModel(rootStatistics.getAccessedDistribution().getTableModel());
        this.accessedDistributionChartModel = new DistributionChartModel(this.accessedDistributionTableModel, resultModel.getGuiSettings());
        this.coloredAccessedDistributionChartModel = new ColoredChartModel<Object>(this.accessedDistributionChartModel, itemLimit, saturation, brightness);
        this.typeDistributionTableModel = new DelegatingTableModel(rootStatistics.getTypeDistribution().getTableModelBySize());
        this.typeDistributionChartModel = new DistributionChartModel(this.typeDistributionTableModel, resultModel.getGuiSettings());
        this.filteredTypeDistributionChartModel = new FilteredChartModel<Object>(this.typeDistributionChartModel, itemLimit, itemThreshold, collapsedText, collapsedColor);
        this.coloredTypeDistributionChartModel = new ColoredChartModel<Object>(this.filteredTypeDistributionChartModel, itemLimit, saturation, brightness);
        this.initEventHandling();
    }

    TreeChartModel<AbstractNode> getTreeChartModel() {
        return this.treeChartModel;
    }

    ChartModel<AbstractNode> getSizeChartModel() {
        return this.coloredSizeChartModel;
    }

    TableModel getSizeTableModel() {
        return this.sizeTableModel;
    }

    TableModel getLargestFilesTableModel() {
        return this.largestFilesTableModel;
    }

    ListSelectionModel getLargestFilesSelectionModel() {
        return this.largestFilesSelectionModel;
    }

    TableModel getLeastRecentlyModifiedFilesTableModel() {
        return this.leastRecentlyModifiedFilesTableModel;
    }

    TableModel getMostRecentlyModifiedFilesTableModel() {
        return this.mostRecentlyModifiedFilesTableModel;
    }

    TableModel getLeastRecentlyAccessedFilesTableModel() {
        return this.leastRecentlyAccessedFilesTableModel;
    }

    TableModel getMostRecentlyAccessedFilesTableModel() {
        return this.mostRecentlyAccessedFilesTableModel;
    }

    TableModel getLeastRecentlyUsedFilesTableModel() {
        return this.leastRecentlyUsedFilesTableModel;
    }

    TableModel getMostRecentlyUsedFilesTableModel() {
        return this.mostRecentlyUsedFilesTableModel;
    }

    ChartModel<Object> getSizeDistributionChartModel() {
        return this.coloredSizeDistributionChartModel;
    }

    TableModel getSizeDistributionTableModel() {
        return this.sizeDistributionTableModel;
    }

    ChartModel<Object> getModifiedDistributionChartModel() {
        return this.coloredModifiedDistributionChartModel;
    }

    TableModel getModifiedDistributionTableModel() {
        return this.modifiedDistributionTableModel;
    }

    ChartModel<Object> getAccessedDistributionChartModel() {
        return this.coloredAccessedDistributionChartModel;
    }

    TableModel getAccessedDistributionTableModel() {
        return this.accessedDistributionTableModel;
    }

    ChartModel<Object> getTypeDistributionChartModel() {
        return this.coloredTypeDistributionChartModel;
    }

    TableModel getTypeDistributionTableModel() {
        return this.typeDistributionTableModel;
    }

    private TableModel getSizeTableModel(DirectoryNode directoryNode) {
        GUISettings.SortMode sortMode = this.resultModel.getGuiSettings().getSortMode();
        GUISettings.SizeMode sizeMode = this.resultModel.getGuiSettings().getSizeMode();
        boolean showFiles = this.resultModel.getGuiSettings().getShowFiles();
        return directoryNode.getTableModel(sortMode, sizeMode, showFiles);
    }

    private TreeChartModel<AbstractNode> getTreeChartModel(DirectoryNode directoryNode) {
        GUISettings.SortMode sortMode = this.resultModel.getGuiSettings().getSortMode();
        GUISettings.SizeMode sizeMode = this.resultModel.getGuiSettings().getSizeMode();
        boolean showFiles = this.resultModel.getGuiSettings().getShowFiles();
        return directoryNode.getTreeChartModel(sortMode, sizeMode, showFiles);
    }

    private void initEventHandling() {
        this.resultModel.getGuiSettings().addPropertyChangeListener(this::onGuiSettingsChanged);
        this.resultModel.getGuiSettings().chartSettings().addPropertyChangeListener(this::onChartSettingsChanged);
        this.resultModel.getNavigationModel().addPropertyChangeListener("selection", this::onNavigationSelectionChanged);
        this.updateSelection(this.resultModel.getNavigationModel().getSelection());
    }

    void onLargestFileContextMenuRequested(MouseEvent evt) {
        new PopupMenuBuilder().item(RESOURCES.getString("OpenFileInFileView.Action.text", new Object[0]), this::onOpenFolderInFileViewPerformed).show(evt);
    }

    private void onOpenFolderInFileViewPerformed(ActionEvent evt) {
        int index = this.largestFilesSelectionModel.getMinSelectionIndex();
        Statistics rootStatistics = this.resultModel.getRootNode().getStatistics();
        FileNode node = rootStatistics.getLargestFiles().get(index);
        JDApplicationModel.onOpenFileInFileView(evt, node);
    }

    private void onGuiSettingsChanged(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("sortMode".equals(propertyName) || "sizeMode".equals(propertyName) || "showFiles".equals(propertyName)) {
            this.updateSelection(this.resultModel.getNavigationModel().getSelection());
        }
    }

    private void onChartSettingsChanged(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "brightness": 
            case "saturation": {
                this.updateColoredModels();
                break;
            }
            case "elementLimit": {
                this.updateFilteredModels();
                break;
            }
        }
    }

    private void onNavigationSelectionChanged(PropertyChangeEvent evt) {
        DirectoryNode selection = (DirectoryNode)evt.getNewValue();
        this.updateSelection(selection);
    }

    private void updateSelection(DirectoryNode selection) {
        if (selection == null) {
            return;
        }
        TreeChartModel<AbstractNode> aTreeChartModel = this.getTreeChartModel(selection);
        this.treeChartModel.setDelegate(aTreeChartModel);
        TableModel aSizeTableModel = this.getSizeTableModel(selection);
        this.sizeTableModel.setDelegate(aSizeTableModel);
        Statistics statistics = selection.getStatistics();
        if (statistics != null) {
            this.largestFilesTableModel.setDelegate(statistics.getLargestFiles().getTableModel());
            this.leastRecentlyModifiedFilesTableModel.setDelegate(statistics.getLeastRecentlyModifiedFiles().getTableModel());
            this.mostRecentlyModifiedFilesTableModel.setDelegate(statistics.getMostRecentlyModifiedFiles().getTableModel());
            this.leastRecentlyAccessedFilesTableModel.setDelegate(statistics.getLeastRecentlyAccessedFiles().getTableModel());
            this.mostRecentlyAccessedFilesTableModel.setDelegate(statistics.getMostRecentlyAccessedFiles().getTableModel());
            this.leastRecentlyUsedFilesTableModel.setDelegate(statistics.getLeastRecentlyUsedFiles().getTableModel());
            this.mostRecentlyUsedFilesTableModel.setDelegate(statistics.getMostRecentlyUsedFiles().getTableModel());
            TableModel sizeDistTableModel = statistics.getSizeDistribution().getTableModel();
            this.sizeDistributionTableModel.setDelegate(sizeDistTableModel);
            TableModel modifiedDistTableModel = statistics.getModifiedDistribution().getTableModel();
            this.modifiedDistributionTableModel.setDelegate(modifiedDistTableModel);
            TableModel accessedDistTableModel = statistics.getAccessedDistribution().getTableModel();
            this.accessedDistributionTableModel.setDelegate(accessedDistTableModel);
            TableModel typeDistTableModel = statistics.getTypeDistribution().getTableModelBySize();
            this.typeDistributionTableModel.setDelegate(typeDistTableModel);
        }
    }

    private void updateColoredModels() {
        ChartSettings chartSettings = this.resultModel.getGuiSettings().chartSettings();
        int colorCount = chartSettings.getElementLimit();
        float saturation = chartSettings.getSaturation();
        float brightness = chartSettings.getBrightness();
        this.coloredSizeChartModel.setColorCount(colorCount);
        this.coloredSizeChartModel.setSaturation(saturation);
        this.coloredSizeChartModel.setBrightness(brightness);
        this.coloredSizeDistributionChartModel.setColorCount(colorCount);
        this.coloredSizeDistributionChartModel.setSaturation(saturation);
        this.coloredSizeDistributionChartModel.setBrightness(brightness);
        this.coloredModifiedDistributionChartModel.setColorCount(colorCount);
        this.coloredModifiedDistributionChartModel.setSaturation(saturation);
        this.coloredModifiedDistributionChartModel.setBrightness(brightness);
        this.coloredTypeDistributionChartModel.setColorCount(colorCount);
        this.coloredTypeDistributionChartModel.setSaturation(saturation);
        this.coloredTypeDistributionChartModel.setBrightness(brightness);
    }

    private void updateFilteredModels() {
        ChartSettings chartSettings = this.resultModel.getGuiSettings().chartSettings();
        int elementLimit = chartSettings.getElementLimit();
        this.filteredSizeChartModel.setItemLimit(elementLimit);
    }

    private static final class ChartUpdater
    implements TableModelListener {
        private final AbstractChartModel<?> chartModel;

        ChartUpdater(AbstractChartModel<?> chartModel) {
            this.chartModel = chartModel;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.chartModel.fireStateChanged();
        }
    }

    private static final class DelegatingTableModel
    extends AbstractTableModel {
        private TableModel delegate;

        DelegatingTableModel(TableModel delegate) {
            this.delegate = delegate;
        }

        void setDelegate(TableModel newDelegate) {
            if (this.delegate == newDelegate) {
                return;
            }
            this.delegate = newDelegate;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.delegate.getColumnName(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.delegate.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.delegate.getRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.delegate.getValueAt(rowIndex, columnIndex);
        }
    }

    private static final class DelegatingTreeChartModel<T>
    extends AbstractTreeChartModel<T> {
        private TreeChartModel<T> delegate;

        DelegatingTreeChartModel(TreeChartModel<T> delegate) {
            this.delegate = delegate;
        }

        void setDelegate(TreeChartModel<T> newDelegate) {
            TreeChartModel<T> oldDelegate = this.delegate;
            if (oldDelegate == newDelegate) {
                return;
            }
            this.delegate = newDelegate;
            this.fireStateChanged();
        }

        @Override
        public T getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public int getChildCount(T node) {
            return this.delegate.getChildCount(node);
        }

        @Override
        public T getChild(T node, int index) {
            return this.delegate.getChild(node, index);
        }

        @Override
        public long getSize(T node) {
            return this.delegate.getSize(node);
        }

        @Override
        public boolean isLeaf(T node) {
            return this.delegate.isLeaf(node);
        }
    }

    public static final class DistributionChartModel
    extends AbstractChartModel<Object> {
        private final TableModel tableModel;
        private final GUISettings guiSettings;

        DistributionChartModel(TableModel tableModel, GUISettings guiSettings) {
            this.tableModel = tableModel;
            this.guiSettings = guiSettings;
            this.initEventHandling();
        }

        private void initEventHandling() {
            this.tableModel.addTableModelListener(this::onTableChanged);
        }

        @Override
        public int getItemCount() {
            return this.tableModel.getRowCount();
        }

        @Override
        public Object getData(int index) {
            return null;
        }

        @Override
        public Icon getIcon(int index) {
            return null;
        }

        @Override
        public String getText(int index) {
            return (String)this.tableModel.getValueAt(index, 0);
        }

        @Override
        public long getSize(int index) {
            GUISettings.SizeMode sizeMode = this.guiSettings.getSizeMode();
            int columnIndex = sizeMode == GUISettings.SizeMode.SIZE ? 1 : 3;
            return (Long)this.tableModel.getValueAt(index, columnIndex);
        }

        @Override
        public Color getColor(int index) {
            return null;
        }

        void onTableChanged(TableModelEvent evt) {
            this.fireStateChanged();
        }
    }

    private static final class SizeChartModel
    extends AbstractChartModel<AbstractNode> {
        private final TableModel tableModel;
        private final GUISettings guiSettings;

        SizeChartModel(TableModel tableModel, GUISettings guiSettings) {
            this.tableModel = tableModel;
            this.guiSettings = guiSettings;
            tableModel.addTableModelListener(new ChartUpdater(this));
        }

        @Override
        public int getItemCount() {
            return this.tableModel.getRowCount();
        }

        @Override
        public AbstractNode getData(int index) {
            return (AbstractNode)this.tableModel.getValueAt(index, 0);
        }

        @Override
        public Icon getIcon(int index) {
            return this.getData(index).getIcon(false);
        }

        @Override
        public String getText(int index) {
            AbstractNode node = this.getData(index);
            String name = node.getName();
            return node.isFileLeaf() ? name : File.separator + name;
        }

        @Override
        public long getSize(int index) {
            GUISettings.SizeMode sizeMode = this.guiSettings.getSizeMode();
            return sizeMode == GUISettings.SizeMode.SIZE ? this.getData(index).getSize() : this.getData(index).getFileCount();
        }

        @Override
        public Color getColor(int index) {
            return null;
        }
    }
}

