/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.syntax.Token;

public class TextPosition
implements Comparable<TextPosition> {
    public static final TextPosition NOT_AVAILABLE = new TextPosition(-1, -1);
    private final int line;
    private final int column;

    private TextPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLineIndex() {
        return this.line - 1;
    }

    public int getColumnIndex() {
        return this.column - 1;
    }

    public TextPosition shiftVertically(int numLines) {
        return TextPosition.create(this.line + numLines, this.column);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextPosition other = (TextPosition)obj;
        return this.line == other.line && this.column == other.column;
    }

    public int hashCode() {
        return this.line * 31 + this.column;
    }

    public String toString() {
        return String.format("(%d,%d)", this.line, this.column);
    }

    @Override
    public int compareTo(TextPosition other) {
        if (this.line != other.line) {
            return this.line - other.line;
        }
        return this.column - other.column;
    }

    public static TextPosition startOf(Token token) {
        return TextPosition.create(token.getStartLine(), token.getStartColumn());
    }

    public static TextPosition startOf(ASTNode node) {
        return TextPosition.create(node.getLineNumber(), node.getColumnNumber());
    }

    public static TextPosition endOf(ASTNode node) {
        return TextPosition.create(node.getLastLineNumber(), node.getLastColumnNumber());
    }

    public static TextPosition create(int line, int column) {
        if (line < 1 || column < 1) {
            return NOT_AVAILABLE;
        }
        return new TextPosition(line, column);
    }
}

