/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class BAVibroClawAttackAction
extends AbstractAttackAction {
    private static final long serialVersionUID = 1432011536091665084L;

    public BAVibroClawAttackAction(int n, int n2) {
        super(n, n2);
    }

    public BAVibroClawAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public static int getDamageFor(Entity entity) {
        return Compute.missilesHit(((BattleArmor)entity).getShootingStrength()) * entity.getVibroClaws();
    }

    public ToHitData toHit(IGame iGame) {
        return BAVibroClawAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        int n2 = -1;
        Entity entity2 = null;
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n2 = targetable.getTargetId();
        }
        if (!iGame.getOptions().booleanOption("friendly_fire") && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
            return new ToHitData(Integer.MAX_VALUE, "A friendly unit can never be the target of a direct attack.");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        if (iHex == null || iHex2 == null) {
            return new ToHitData(Integer.MAX_VALUE, "off board");
        }
        boolean bl = Compute.isInSameBuilding(iGame, entity, entity2);
        if (entity2 != null && entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (!(entity instanceof BattleArmor)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-BA can't make vibroclaw-physicalattacks");
        }
        if (entity2 != null && !(entity2 instanceof Infantry)) {
            return new ToHitData(Integer.MAX_VALUE, "can't target non-infantry");
        }
        if (entity.getVibroClaws() == 0) {
            return new ToHitData(Integer.MAX_VALUE, "no vibro claws mounted");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        int n3 = entity.getPosition().distance(targetable.getPosition());
        if (n3 > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (entity2 != null && entity2.getElevation() > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity2 != null && entity2.isMakingDfa()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a DFA attack");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n4 = entity.getCrew().getGunnery();
        ToHitData toHitData = new ToHitData(n4, "base");
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2, 0, bl));
        if (entity.isSpotting()) {
            toHitData.addModifier(1, "attacker is spotting");
        }
        if (entity.getTaserFeedBackRounds() > 0) {
            toHitData.addModifier(1, "Taser feedback");
        }
        toHitData.append(Compute.getImmobileMod(entity2));
        toHitData.append(BAVibroClawAttackAction.nightModifiers(iGame, targetable, null, entity, false));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        toHitData.setSideTable(Compute.targetSideTable(entity, (Targetable)entity2));
        return toHitData;
    }
}

