/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DefaultPendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DownloadMetadataOperation;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RejectedModuleMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultCapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolver;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ResolveContextToComponentResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final ModuleConflictHandler moduleConflictHandler;
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final ResolveContextToComponentResolver moduleResolver;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleExclusions moduleExclusions;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ModuleReplacementsData moduleReplacementsData;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CapabilitiesConflictHandler capabilitiesConflictHandler;
    private final VersionSelectorScheme versionSelectorScheme;
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;

    public DependencyGraphBuilder(DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ResolveContextToComponentResolver resolveContextToComponentResolver, ModuleConflictHandler moduleConflictHandler, CapabilitiesConflictHandler capabilitiesConflictHandler, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ModuleExclusions moduleExclusions, BuildOperationExecutor buildOperationExecutor, ModuleReplacementsData moduleReplacementsData, DependencySubstitutionApplicator dependencySubstitutionApplicator, ComponentSelectorConverter componentSelectorConverter, ImmutableAttributesFactory attributesFactory, VersionSelectorScheme versionSelectorScheme, Comparator<Version> versionComparator, VersionParser versionParser) {
        this.idResolver = componentIdResolver;
        this.metaDataResolver = componentMetaDataResolver;
        this.moduleResolver = resolveContextToComponentResolver;
        this.moduleConflictHandler = moduleConflictHandler;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleExclusions = moduleExclusions;
        this.buildOperationExecutor = buildOperationExecutor;
        this.moduleReplacementsData = moduleReplacementsData;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributesFactory = attributesFactory;
        this.capabilitiesConflictHandler = capabilitiesConflictHandler;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public void resolve(ResolveContext resolveContext, DependencyGraphVisitor modelVisitor) {
        LongIdGenerator idGenerator = new LongIdGenerator();
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(resolveContext, rootModule);
        ResolveState resolveState = new ResolveState((IdGenerator<Long>)idGenerator, rootModule, resolveContext.getName(), this.idResolver, this.metaDataResolver, this.edgeFilter, this.attributesSchema, this.moduleExclusions, this.moduleReplacementsData, this.componentSelectorConverter, this.attributesFactory, this.dependencySubstitutionApplicator, this.versionSelectorScheme, this.versionComparator, this.versionParser);
        this.traverseGraph(resolveState);
        this.validateGraph(resolveState);
        this.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(ResolveState resolveState) {
        resolveState.onMoreSelected(resolveState.getRoot());
        ArrayList dependencies = Lists.newArrayList();
        HashMap componentIdentifierCache = Maps.newHashMap();
        DefaultPendingDependenciesHandler pendingDependenciesHandler = new DefaultPendingDependenciesHandler();
        while (resolveState.peek() != null || this.moduleConflictHandler.hasConflicts() || this.capabilitiesConflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                NodeState node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                this.registerCapabilities(resolveState, node.getComponent());
                dependencies.clear();
                node.visitOutgoingDependencies(dependencies, pendingDependenciesHandler);
                this.resolveEdges(node, dependencies, resolveState, componentIdentifierCache);
                continue;
            }
            if (this.moduleConflictHandler.hasConflicts()) {
                this.moduleConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
                continue;
            }
            this.capabilitiesConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
        }
    }

    private void registerCapabilities(final ResolveState resolveState, final ComponentState moduleRevision) {
        moduleRevision.forEachCapability((Action<? super Capability>)new Action<Capability>(){

            public void execute(Capability capability) {
                PotentialConflict c;
                Collection<ComponentState> implicitProvidersForCapability = Collections.emptyList();
                for (ModuleResolveState state : resolveState.getModules()) {
                    if (!state.getId().getGroup().equals(capability.getGroup()) || !state.getId().getName().equals(capability.getName())) continue;
                    implicitProvidersForCapability = state.getVersions();
                    break;
                }
                if ((c = DependencyGraphBuilder.this.capabilitiesConflictHandler.registerCandidate(DefaultCapabilitiesConflictHandler.candidate(moduleRevision, capability, implicitProvidersForCapability))).conflictExists()) {
                    c.withParticipatingModules(resolveState.getDeselectVersionAction());
                }
            }
        });
    }

    private void resolveEdges(NodeState node, List<EdgeState> dependencies, ResolveState resolveState, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        if (dependencies.isEmpty()) {
            return;
        }
        this.performSelectionSerially(dependencies, resolveState);
        this.maybeDownloadMetadataInParallel(node, componentIdentifierCache, dependencies);
        this.attachToTargetRevisionsSerially(dependencies);
    }

    private void performSelectionSerially(List<EdgeState> dependencies, ResolveState resolveState) {
        for (EdgeState dependency : dependencies) {
            SelectorState selector = dependency.getSelector();
            ModuleResolveState module = selector.getTargetModule();
            if (!selector.isResolved()) {
                this.performSelection(resolveState, module);
            }
            module.addUnattachedDependency(dependency);
        }
    }

    private void performSelection(ResolveState resolveState, ModuleResolveState module) {
        ComponentState selected;
        ComponentState currentSelection = module.getSelected();
        SelectorStateResolver<ComponentState> selectorStateResolver = new SelectorStateResolver<ComponentState>(this.moduleConflictHandler.getResolver(), resolveState, resolveState.getRoot().getComponent());
        try {
            selected = selectorStateResolver.selectBest(module.getId(), module.getSelectors());
        }
        catch (ModuleVersionResolveException e) {
            return;
        }
        if (currentSelection == null) {
            module.select(selected);
            this.checkForModuleConflicts(resolveState, module);
            return;
        }
        if (selected == currentSelection) {
            return;
        }
        module.changeSelection(selected);
    }

    private void checkForModuleConflicts(ResolveState resolveState, ModuleResolveState module) {
        PotentialConflict c = this.moduleConflictHandler.registerCandidate(module);
        if (c.conflictExists()) {
            LOGGER.debug("Found new conflicting module {}", (Object)module);
            c.withParticipatingModules(resolveState.getDeselectVersionAction());
        }
    }

    private void maybeDownloadMetadataInParallel(NodeState node, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache, List<EdgeState> dependencies) {
        List requiringDownload = null;
        for (EdgeState dependency : dependencies) {
            ComponentState targetComponent = dependency.getTargetComponent();
            if (targetComponent == null || !targetComponent.isSelected() || targetComponent.alreadyResolved() || this.metaDataResolver.isFetchingMetadataCheap(this.toComponentId(targetComponent.getId(), componentIdentifierCache))) continue;
            if (requiringDownload == null) {
                requiringDownload = Lists.newArrayList();
            }
            requiringDownload.add(targetComponent);
        }
        if (requiringDownload != null && requiringDownload.size() > 1) {
            final ImmutableList toDownloadInParallel = ImmutableList.copyOf((Collection)requiringDownload);
            LOGGER.debug("Submitting {} metadata files to resolve in parallel for {}", (Object)toDownloadInParallel.size(), (Object)node);
            this.buildOperationExecutor.runAll((Action)new Action<BuildOperationQueue<RunnableBuildOperation>>(){

                public void execute(BuildOperationQueue<RunnableBuildOperation> buildOperationQueue) {
                    for (ComponentState componentState : toDownloadInParallel) {
                        buildOperationQueue.add((BuildOperation)new DownloadMetadataOperation(componentState));
                    }
                }
            });
        }
    }

    private ComponentIdentifier toComponentId(ModuleVersionIdentifier id, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        ComponentIdentifier identifier = componentIdentifierCache.get(id);
        if (identifier == null) {
            identifier = DefaultModuleComponentIdentifier.newId(id);
            componentIdentifierCache.put(id, identifier);
        }
        return identifier;
    }

    private void attachToTargetRevisionsSerially(List<EdgeState> dependencies) {
        for (EdgeState dependency : dependencies) {
            dependency.attachToTargetConfigurations();
        }
    }

    private void validateGraph(ResolveState resolveState) {
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null || !module.getSelected().isRejected()) continue;
            GradleException error = new GradleException(new RejectedModuleMessageBuilder().buildFailureMessage(module));
            this.attachFailureToEdges(error, module.getIncomingEdges());
            this.attachFailureToEdges(error, module.getUnattachedDependencies());
        }
    }

    private void attachFailureToEdges(GradleException error, Collection<EdgeState> incomingEdges) {
        for (EdgeState edge : incomingEdges) {
            edge.failWith((Throwable)error);
        }
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor visitor) {
        visitor.start(resolveState.getRoot());
        for (DependencyGraphSelector dependencyGraphSelector : resolveState.getSelectors()) {
            visitor.visitSelector(dependencyGraphSelector);
        }
        for (NodeState nodeState : resolveState.getNodes()) {
            if (!nodeState.isSelected()) continue;
            visitor.visitNode(nodeState);
        }
        ArrayList queue = Lists.newArrayListWithExpectedSize((int)resolveState.getNodeCount());
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null) continue;
            queue.add(module.getSelected());
        }
        while (!queue.isEmpty()) {
            ComponentState componentState = (ComponentState)queue.get(0);
            if (componentState.getVisitState() == VisitState.NotSeen) {
                componentState.setVisitState(VisitState.Visiting);
                int pos = 0;
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    for (EdgeState edge : node.getIncomingEdges()) {
                        ComponentState owner = edge.getFrom().getOwner();
                        if (owner.getVisitState() != VisitState.NotSeen) continue;
                        queue.add(pos, owner);
                        ++pos;
                    }
                }
                if (pos != 0) continue;
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            if (componentState.getVisitState() == VisitState.Visiting) {
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            queue.remove(0);
        }
        visitor.finish(resolveState.getRoot());
    }

    static enum VisitState {
        NotSeen,
        Visiting,
        Visited;

    }
}

