/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class LayoutImage
extends EDialog {
    private JButton cancel;
    private JTextField fileName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField largestDotWidth;
    private JTextField minimumGutter;
    private JCheckBox monochrome;
    private JButton ok;
    private JButton openFileButton;
    private JCheckBox reverseVideo;
    private JTextField smallestDotWidth;
    private JComboBox textLayer;

    public LayoutImage(Frame parent) {
        super(parent, true);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.largestDotWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.smallestDotWidth);
        EDialog.makeTextFieldSelectAllOnTab(this.minimumGutter);
        EDialog.makeTextFieldSelectAllOnTab(this.fileName);
        this.largestDotWidth.setText("32");
        this.smallestDotWidth.setText("22");
        this.minimumGutter.setText("16");
        this.monochrome.setSelected(false);
        this.reverseVideo.setSelected(false);
        Technology tech = Technology.getCurrent();
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            this.textLayer.addItem(np.getName());
        }
        this.finishInitialization();
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.smallestDotWidth = new JTextField();
        this.jLabel2 = new JLabel();
        this.largestDotWidth = new JTextField();
        this.jLabel3 = new JLabel();
        this.minimumGutter = new JTextField();
        this.jLabel5 = new JLabel();
        this.textLayer = new JComboBox();
        this.reverseVideo = new JCheckBox();
        this.monochrome = new JCheckBox();
        this.fileName = new JTextField();
        this.jLabel4 = new JLabel();
        this.openFileButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Layout Image");
        this.getContentPane().setLayout(new GridBagLayout());
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutImage.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutImage.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Width of smallest dot:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.smallestDotWidth.setColumns(8);
        this.smallestDotWidth.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.smallestDotWidth, gridBagConstraints);
        this.jLabel2.setText("Width of largest dot:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.largestDotWidth.setColumns(8);
        this.largestDotWidth.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.largestDotWidth, gridBagConstraints);
        this.jLabel3.setText("Minimum gutter between dots:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.minimumGutter.setColumns(8);
        this.minimumGutter.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.minimumGutter, gridBagConstraints);
        this.jLabel5.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textLayer, gridBagConstraints);
        this.reverseVideo.setText("Reverse-video");
        this.reverseVideo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reverseVideo.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.reverseVideo, gridBagConstraints);
        this.monochrome.setText("Monochrome");
        this.monochrome.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.monochrome.setMargin(new Insets(0, 0, 0, 0));
        this.monochrome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutImage.this.monochromeActionPerford(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.monochrome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.getContentPane().add((Component)this.fileName, gridBagConstraints);
        this.jLabel4.setText("Image file name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.openFileButton.setText("Load");
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutImage.this.openFileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 4, 12, 4);
        this.getContentPane().add((Component)this.openFileButton, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void ok(ActionEvent evt) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Technology tech = Technology.getCurrent();
        int minimumGutter = (int)TextUtils.atofDistance(this.minimumGutter.getText(), tech);
        int largestDotWidth = (int)TextUtils.atofDistance(this.largestDotWidth.getText(), tech);
        int smallestDotWidth = (int)TextUtils.atofDistance(this.smallestDotWidth.getText(), tech);
        String layer = (String)this.textLayer.getSelectedItem();
        PrimitiveNode primNode = Technology.getCurrent().findNodeProto(layer);
        if (primNode == null) {
            System.out.println("Cannot find " + layer + " primitive");
            return;
        }
        try {
            ImageReader read;
            String format2;
            File fileURL = new File(this.fileName.getText());
            ImageInputStream iis = ImageIO.createImageInputStream(fileURL);
            if (iis == null) {
                JOptionPane.showMessageDialog(null, "Can't load file '" + this.fileName.getText() + "'", "Erorr in LoadImage", 0);
                return;
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            boolean validFormat = false;
            while (readers.hasNext() && !(validFormat = (format2 = (read = readers.next()).getFormatName().toLowerCase()).equals("jpeg") || format2.equals("png"))) {
            }
            if (!validFormat) {
                String msg = "'" + this.fileName.getText() + "' is not a JPEG file";
                JOptionPane.showMessageDialog(null, msg, "Erorr in LoadImage", 0);
                return;
            }
            Image img = Toolkit.getDefaultToolkit().createImage(this.fileName.getText());
            MediaTracker mediatracker = new MediaTracker(new Canvas());
            mediatracker.addImage(img, 1);
            try {
                mediatracker.waitForAll();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            mediatracker.removeImage(img);
            BufferedImage textImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 10);
            textImage.getGraphics().drawImage(img, 0, 0, null);
            Raster ras = textImage.getData();
            DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
            this.setVisible(false);
            this.dispose();
            new LayoutImageJob(ras.getWidth(), ras.getHeight(), ras.getWidth() / 2, -ras.getHeight() / 2, dbb.getData(), largestDotWidth + minimumGutter, largestDotWidth, smallestDotWidth, primNode, curCell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void monochromeActionPerford(ActionEvent evt) {
    }

    private void openFileButtonActionPerformed(ActionEvent evt) {
        String fn = OpenFile.chooseInputFile(FileType.ANY, null, null);
        if (fn == null) {
            return;
        }
        this.fileName.setText(fn);
    }

    private static class LayoutImageJob
    extends Job {
        int width;
        int height;
        int xOffset;
        int yOffset;
        byte[] samples;
        int scale;
        int largestDotWidth;
        int smallestDotWidth;
        NodeProto primNode;
        Cell curCell;

        public LayoutImageJob(int width, int height, int xOffset, int yOffset, byte[] samples, int scale, int largestDotWidth, int smallestDotWidth, NodeProto primNode, Cell curCell) {
            super("Create Layout Image", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.width = width;
            this.height = height;
            this.samples = samples;
            this.scale = scale;
            this.largestDotWidth = largestDotWidth;
            this.smallestDotWidth = smallestDotWidth;
            this.primNode = primNode;
            this.curCell = curCell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            int samp = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int w;
                    if ((w = (int)((float)(255 - (this.samples[samp++] & 0xFF)) / 255.0f * (float)(this.largestDotWidth - this.smallestDotWidth)) + this.smallestDotWidth) == this.smallestDotWidth) continue;
                    Point2D.Double center = new Point2D.Double((x - this.xOffset) * this.scale, -(y + this.yOffset) * this.scale);
                    NodeInst.newInstance(this.primNode, ep, center, w, w, this.curCell);
                }
            }
            return true;
        }
    }
}

