/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import java.util.ArrayList;
import java.util.List;

public class State
implements Comparable {
    private static final List<State> statuses = new ArrayList<State>();
    public static final State UPDATE = new State("U", "Needs Update", "Updated", 3);
    public static final State PATCHED = new State("P", "Needs Patch", "Patched", 4);
    public static final State ADDED = new State("A", "Locally Added", "Added", 5);
    public static final State REMOVED = new State("R", "Locally Removed", "Removed", 6);
    public static final State MODIFIED = new State("M", "Locally Modified", "Locally Modified", 2);
    public static final State CONFLICT = new State("C", "Conflicts With Repository", "Has Conflicts", 1);
    public static final State UNKNOWN = new State("?", "Unknown", "Unknown", 7);
    public static final State NONE = new State("", "None", "None", 8);
    private final String key;
    private final String state;
    private final String updateResult;
    private final int sortkey;

    private State(String key, String state, String updateResult, int sortkey) {
        this.key = key;
        this.state = state;
        this.updateResult = updateResult;
        this.sortkey = sortkey;
        statuses.add(this);
    }

    public final String getState() {
        return this.state;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getUpdateResult() {
        return this.updateResult;
    }

    public static State getState(String key) {
        for (State s2 : statuses) {
            if (!s2.getKey().equals(key)) continue;
            return s2;
        }
        return null;
    }

    public int compareTo(Object o) {
        State s2 = (State)o;
        if (this == s2) {
            return 0;
        }
        if (this.sortkey < s2.sortkey) {
            return -1;
        }
        return 1;
    }
}

