/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNet;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.util.collections.ArrayIterator;
import java.util.Arrays;
import java.util.IdentityHashMap;

public class ImmutableNetLayout
extends ImmutableNet {
    final int[] equivPortsN;
    final int[] equivPortsP;
    final int[] equivPortsA;
    private final IdentityHashMap<NodeProtoId, NodeProtoInfo> nodeProtoInfos = new IdentityHashMap();
    private final IdentityHashMap<PortProtoId, Void> isolatedPorts = new IdentityHashMap();
    final int[] netMap;
    private static final int[] EQUIV_PORTS_1 = new int[]{0};

    public ImmutableNetLayout(CellTree cellTree) {
        super(cellTree);
        NodeProtoInfo npi;
        ImmutableNodeInst n;
        int nodeIndex;
        int nodeBase = this.numExports;
        for (ImmutableNodeInst n2 : this.cellRevision.nodes) {
            NodeProtoInfo npi2 = this.nodeProtoInfos.get(n2.protoId);
            if (npi2 == null) {
                PrimitiveNode pn;
                npi2 = new NodeProtoInfo(cellTree, n2.protoId);
                this.nodeProtoInfos.put(n2.protoId, npi2);
                if (n2.protoId instanceof PrimitiveNodeId && (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId)).getTechnology() == this.schemTech) {
                    for (PrimitivePort pp : ArrayIterator.i2i(pn.getPrimitivePorts())) {
                        if (!pp.isIsolated()) continue;
                        this.isolatedPorts.put(pp.getId(), null);
                    }
                }
            }
            nodeBase += npi2.numPorts;
        }
        this.netMap = ImmutableNetLayout.initMap(nodeBase);
        this.connectExports();
        this.connectArcs();
        this.equivPortsN = this.computePortsN();
        this.equivPortsP = this.computePortsP();
        this.equivPortsA = this.computePortsA();
        int[] drawnMap = ImmutableNetLayout.initMap(this.numExports + this.numDrawns);
        for (int exportIndex = 0; exportIndex < this.numExports; ++exportIndex) {
            ImmutableNetLayout.connectMap(drawnMap, exportIndex, this.numExports + this.drawns[exportIndex]);
        }
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n = this.nodes.get(nodeIndex);
            npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.numPorts == 1) continue;
            this.connectInternals(drawnMap, this.numExports, this.ni_pi[nodeIndex], npi.equivPortsN);
        }
        this.checkEquivPorts(this.equivPortsN, drawnMap);
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n = this.nodes.get(nodeIndex);
            npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.numPorts == 1 || npi.equivPortsP == npi.equivPortsN) continue;
            this.connectInternals(drawnMap, this.numExports, this.ni_pi[nodeIndex], npi.equivPortsP);
        }
        this.checkEquivPorts(this.equivPortsP, drawnMap);
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n = this.nodes.get(nodeIndex);
            npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.numPorts == 1 || npi.equivPortsA == npi.equivPortsP) continue;
            this.connectInternals(drawnMap, this.numExports, this.ni_pi[nodeIndex], npi.equivPortsA);
        }
        this.checkEquivPorts(this.equivPortsA, drawnMap);
    }

    private void checkEquivPorts(int[] equivPorts, int[] drawnMap) {
        ImmutableNetLayout.closureMap(drawnMap);
        assert (equivPorts.length == this.numExports);
        for (int exportIndex = 0; exportIndex < equivPorts.length; ++exportIndex) {
            assert (equivPorts[exportIndex] == drawnMap[exportIndex]);
        }
    }

    private int[] computePortsN() {
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.numPorts == 1) continue;
            this.connectInternals(n, npi.equivPortsN);
        }
        return this.equivMap(null);
    }

    private int[] computePortsP() {
        PrimitiveNodeId schemResistor = this.schemTech != null ? this.schemTech.resistorNode.getId() : null;
        boolean changed = false;
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.equivPortsP == npi.equivPortsN || n.protoId == schemResistor && n.techBits != 0 || !this.connectInternals(n, npi.equivPortsP)) continue;
            changed = true;
        }
        return changed ? this.equivMap(this.equivPortsN) : this.equivPortsN;
    }

    private int[] computePortsA() {
        PrimitiveNodeId schemResistor = this.schemTech != null ? this.schemTech.resistorNode.getId() : null;
        boolean changed = false;
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.equivPortsA == npi.equivPortsP && (n.protoId != schemResistor || n.techBits == 0) || !this.connectInternals(n, npi.equivPortsA)) continue;
            changed = true;
        }
        return changed ? this.equivMap(this.equivPortsP) : this.equivPortsP;
    }

    private boolean connectInternals(ImmutableNodeInst n, int[] equivPorts) {
        boolean changed = false;
        int nodeBase = this.ni_pi[this.nodeIndexByNodeId(n.nodeId)];
        for (int i = 1; i < equivPorts.length; ++i) {
            int eq2 = equivPorts[i];
            if (eq2 == i || !ImmutableNetLayout.connectMap(this.netMap, nodeBase + i, nodeBase + eq2)) continue;
            changed = true;
        }
        return changed;
    }

    public int[] getNetMap(Netlist.ShortResistors shortResistors) {
        int[] map2 = ImmutableNetLayout.initMap(this.numDrawns);
        for (int nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            int[] equivPorts;
            ImmutableNodeInst n = this.nodes.get(nodeIndex);
            NodeProtoInfo npi = this.nodeProtoInfos.get(n.protoId);
            if (npi.numPorts == 1) continue;
            switch (shortResistors) {
                case NO: {
                    equivPorts = npi.equivPortsN;
                    break;
                }
                case PARASITIC: {
                    equivPorts = npi.equivPortsP;
                    break;
                }
                case ALL: {
                    equivPorts = npi.equivPortsA;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.connectInternals(map2, 0, this.ni_pi[nodeIndex], equivPorts);
        }
        ImmutableNetLayout.closureMap(map2);
        return map2;
    }

    private boolean connectInternals(int[] map2, int drawnsStart, int nodeBase, int[] equivPorts) {
        boolean changed = false;
        for (int i = 1; i < equivPorts.length; ++i) {
            int eq2 = equivPorts[i];
            if (eq2 == i || !ImmutableNetLayout.connectMap(map2, drawnsStart + this.drawns[nodeBase + i], drawnsStart + this.drawns[nodeBase + eq2])) continue;
            changed = true;
        }
        return changed;
    }

    private void connectExports() {
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            ImmutableExport e = this.cellRevision.exports.get(exportIndex);
            ImmutableNetLayout.connectMap(this.netMap, exportIndex, this.mapIndex(e.originalNodeId, e.originalPortId));
        }
    }

    private void connectArcs() {
        for (ImmutableArcInst a : this.cellRevision.arcs) {
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || !this.isolatedPorts.isEmpty() && (this.isolatedPorts.containsKey(a.tailPortId) || this.isolatedPorts.containsKey(a.headPortId)) || (a.tailPortId == this.busPinPortId || a.headPortId == this.busPinPortId) && ap != this.busArc) continue;
            ImmutableNetLayout.connectMap(this.netMap, this.mapIndex(a.tailNodeId, a.tailPortId), this.mapIndex(a.headNodeId, a.headPortId));
        }
    }

    private int mapIndex(int nodeId, PortProtoId portId) {
        NodeProtoInfo npi = this.nodeProtoInfos.get(portId.parentId);
        return this.ni_pi[this.nodeIndexByNodeId(nodeId)] + npi.portIndexByChron[portId.chronIndex];
    }

    private int[] equivMap(int[] oldMap) {
        ImmutableNetLayout.closureMap(this.netMap);
        if (oldMap != null && oldMap.length == this.numExports) {
            boolean eq2 = true;
            for (int i = 0; i < this.numExports; ++i) {
                if (this.netMap[i] == oldMap[i]) continue;
                eq2 = false;
                break;
            }
            if (eq2) {
                return oldMap;
            }
        }
        int[] map2 = new int[this.numExports];
        System.arraycopy(this.netMap, 0, map2, 0, this.numExports);
        return map2;
    }

    private static class NodeProtoInfo {
        final int numPorts;
        final int[] equivPortsN;
        final int[] equivPortsP;
        final int[] equivPortsA;
        final int[] portIndexByChron;
        final EquivPorts subNet;

        private NodeProtoInfo(CellTree cellTree, NodeProtoId nodeProtoId) {
            if (nodeProtoId instanceof CellId) {
                CellUsage cu = cellTree.top.cellRevision.d.cellId.getUsageIn((CellId)nodeProtoId);
                CellTree subTree = cellTree.subTrees[cu.indexInParent];
                this.subNet = subTree.getEquivPorts();
                this.numPorts = this.subNet.numExports;
                this.equivPortsN = this.subNet.equivPortsN;
                this.equivPortsP = this.subNet.equivPortsP;
                this.equivPortsA = this.subNet.equivPortsA;
                this.portIndexByChron = subTree.top.cellRevision.exportIndex;
            } else {
                PrimitivePort pp;
                int portIndex;
                this.subNet = null;
                PrimitiveNode pn = cellTree.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId);
                this.numPorts = pn.getNumPorts();
                int maxChronId = -1;
                for (portIndex = 0; portIndex < pn.getNumPorts(); ++portIndex) {
                    pp = pn.getPort(portIndex);
                    maxChronId = Math.max(maxChronId, pp.getId().chronIndex);
                }
                this.portIndexByChron = new int[maxChronId + 1];
                Arrays.fill(this.portIndexByChron, -1);
                portIndex = 0;
                while (portIndex < pn.getNumPorts()) {
                    pp = pn.getPort(portIndex);
                    this.portIndexByChron[pp.getId().chronIndex] = portIndex++;
                }
                if (pn.getNumPorts() == 1) {
                    this.equivPortsA = EQUIV_PORTS_1;
                    this.equivPortsP = this.equivPortsA;
                    this.equivPortsN = this.equivPortsA;
                } else {
                    this.equivPortsN = ImmutableNet.initMap(pn.getNumPorts());
                    for (int i = 0; i < pn.getNumPorts(); ++i) {
                        for (int j = i + 1; j < pn.getNumPorts(); ++j) {
                            if (pn.getPort(i).getTopology() != pn.getPort(j).getTopology()) continue;
                            ImmutableNet.connectMap(this.equivPortsN, i, j);
                        }
                    }
                    ImmutableNet.closureMap(this.equivPortsN);
                    PrimitiveNode.Function fun = pn.getFunction();
                    if (fun == PrimitiveNode.Function.RESIST) {
                        assert (this.equivPortsN.length == 2);
                        this.equivPortsA = new int[]{0, 0};
                        this.equivPortsP = this.equivPortsA;
                    } else if (fun.isComplexResistor()) {
                        this.equivPortsP = this.equivPortsN;
                        this.equivPortsA = new int[]{0, 0};
                    } else {
                        this.equivPortsA = this.equivPortsN;
                        this.equivPortsP = this.equivPortsN;
                    }
                }
            }
        }
    }
}

