/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.htmlui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.htmlui.HTMLDialogBase;

@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.METHOD})
public @interface HTMLDialog {
    public String url();

    public String[] resources() default {};

    public String className() default "Pages";

    public String[] techIds() default {};

    public static final class Builder {
        private final String url;
        private List<String> resources = new ArrayList<String>();
        private List<String> techIds = new ArrayList<String>();
        private Runnable onPageLoad;

        private Builder(String string) {
            this.url = string;
        }

        public static Builder newDialog(String string) {
            return new Builder(string);
        }

        public Builder loadFinished(Runnable runnable) {
            this.onPageLoad = runnable;
            return this;
        }

        public Builder addResources(String ... stringArray) {
            this.resources.addAll(Arrays.asList(stringArray));
            return this;
        }

        public Builder addTechIds(String ... stringArray) {
            this.techIds.addAll(Arrays.asList(stringArray));
            return this;
        }

        public String showAndWait() {
            HTMLDialogBase hTMLDialogBase = HTMLDialogBase.create(this.url, this.resources.toArray(new String[0]), this.onPageLoad, null, this.techIds.toArray(new String[0]), null);
            return hTMLDialogBase.showAndWait();
        }

        public void show(OnSubmit onSubmit) {
            HTMLDialogBase hTMLDialogBase = HTMLDialogBase.create(this.url, this.resources.toArray(new String[0]), this.onPageLoad, onSubmit, this.techIds.toArray(new String[0]), null);
            hTMLDialogBase.show(onSubmit);
        }

        public <C> C component(Class<C> clazz) {
            HTMLDialogBase hTMLDialogBase = HTMLDialogBase.create(this.url, this.resources.toArray(new String[0]), this.onPageLoad, null, this.techIds.toArray(new String[0]), clazz);
            return hTMLDialogBase.component(clazz);
        }
    }

    @FunctionalInterface
    public static interface OnSubmit {
        public boolean onSubmit(String var1);
    }
}

