/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.internal.ExecuteDomainObjectCollectionCallbackBuildOperationType;
import org.gradle.api.internal.plugins.ApplyPluginBuildOperationType;
import org.gradle.configuration.ApplyScriptPluginBuildOperationType;
import org.gradle.configuration.internal.ExecuteListenerBuildOperationType;
import org.gradle.internal.build.event.types.DefaultBinaryPluginIdentifier;
import org.gradle.internal.build.event.types.DefaultScriptPluginIdentifier;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalBinaryPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalScriptPluginIdentifier;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;

class PluginApplicationTracker
implements BuildOperationTracker {
    private static final String PROJECT_TARGET_TYPE = "project";
    private final Map<OperationIdentifier, PluginApplication> runningPluginApplications = new ConcurrentHashMap<OperationIdentifier, PluginApplication>();
    private final Map<Long, PluginApplication> pluginApplicationRegistry = new ConcurrentHashMap<Long, PluginApplication>();
    private final BuildOperationAncestryTracker ancestryTracker;

    PluginApplicationTracker(BuildOperationAncestryTracker ancestryTracker) {
        this.ancestryTracker = ancestryTracker;
    }

    @Nullable
    public PluginApplication getRunningPluginApplication(OperationIdentifier id) {
        return this.runningPluginApplications.get(id);
    }

    public boolean hasRunningPluginApplication(OperationIdentifier id, Predicate<? super PluginApplication> predicate) {
        return this.ancestryTracker.findClosestMatchingAncestor(id, parent -> {
            PluginApplication pluginApplication = this.runningPluginApplications.get(parent);
            return pluginApplication != null && predicate.test(pluginApplication);
        }).isPresent();
    }

    @Nullable
    public PluginApplication findRunningPluginApplication(OperationIdentifier id) {
        return this.ancestryTracker.findClosestExistingAncestor(id, this.runningPluginApplications::get).orElse(null);
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getDetails() instanceof ApplyPluginBuildOperationType.Details) {
            ApplyPluginBuildOperationType.Details details = (ApplyPluginBuildOperationType.Details)buildOperation.getDetails();
            this.createAndTrack(buildOperation, details.getTargetType(), details.getApplicationId(), () -> this.toBinaryPluginIdentifier(details));
        } else if (buildOperation.getDetails() instanceof ApplyScriptPluginBuildOperationType.Details) {
            ApplyScriptPluginBuildOperationType.Details details = (ApplyScriptPluginBuildOperationType.Details)buildOperation.getDetails();
            this.createAndTrack(buildOperation, details.getTargetType(), details.getApplicationId(), () -> this.toScriptPluginIdentifier(details));
        } else if (buildOperation.getDetails() instanceof ExecuteListenerBuildOperationType.Details) {
            ExecuteListenerBuildOperationType.Details details = (ExecuteListenerBuildOperationType.Details)buildOperation.getDetails();
            this.lookupAndTrack(buildOperation, details.getApplicationId());
        } else if (buildOperation.getDetails() instanceof ExecuteDomainObjectCollectionCallbackBuildOperationType.Details) {
            ExecuteDomainObjectCollectionCallbackBuildOperationType.Details details = (ExecuteDomainObjectCollectionCallbackBuildOperationType.Details)buildOperation.getDetails();
            this.lookupAndTrack(buildOperation, details.getApplicationId());
        }
    }

    private void createAndTrack(BuildOperationDescriptor buildOperation, String targetType, long applicationId, Supplier<InternalPluginIdentifier> pluginSupplier) {
        InternalPluginIdentifier plugin;
        if (PROJECT_TARGET_TYPE.equals(targetType) && (plugin = pluginSupplier.get()) != null) {
            PluginApplication pluginApplication = new PluginApplication(applicationId, plugin);
            this.pluginApplicationRegistry.put(applicationId, pluginApplication);
            this.track(buildOperation, pluginApplication);
        }
    }

    private void lookupAndTrack(BuildOperationDescriptor buildOperation, long applicationId) {
        PluginApplication pluginApplication = this.pluginApplicationRegistry.get(applicationId);
        if (pluginApplication != null) {
            this.track(buildOperation, pluginApplication);
        }
    }

    private void track(BuildOperationDescriptor buildOperation, PluginApplication pluginApplication) {
        this.runningPluginApplications.put(buildOperation.getId(), pluginApplication);
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
    }

    @Override
    public void discardState(BuildOperationDescriptor buildOperation) {
        this.runningPluginApplications.remove(buildOperation.getId());
    }

    private InternalBinaryPluginIdentifier toBinaryPluginIdentifier(ApplyPluginBuildOperationType.Details details) {
        String className = details.getPluginClass().getName();
        String pluginId = details.getPluginId();
        String displayName = (String)MoreObjects.firstNonNull((Object)pluginId, (Object)className);
        return new DefaultBinaryPluginIdentifier(displayName, className, pluginId);
    }

    private InternalScriptPluginIdentifier toScriptPluginIdentifier(ApplyScriptPluginBuildOperationType.Details details) {
        String fileString = details.getFile();
        if (fileString != null) {
            File file = new File(fileString);
            return new DefaultScriptPluginIdentifier(file.getName(), file.toURI());
        }
        String uriString = details.getUri();
        if (uriString != null) {
            URI uri = URI.create(uriString);
            return new DefaultScriptPluginIdentifier(FilenameUtils.getName((String)uri.getPath()), uri);
        }
        return null;
    }

    static class PluginApplication {
        private final long applicationId;
        private final InternalPluginIdentifier plugin;

        PluginApplication(long applicationId, InternalPluginIdentifier plugin) {
            this.applicationId = applicationId;
            this.plugin = plugin;
        }

        public long getApplicationId() {
            return this.applicationId;
        }

        public InternalPluginIdentifier getPlugin() {
            return this.plugin;
        }
    }
}

