/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import mill.api.ClassLoader$;
import mill.api.Ctx;
import mill.api.Logger;
import mill.moduledefs.Scaladoc;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Scaladoc(value="/**\n * Utilities for creating classloaders for running compiled Java/Scala code in\n * isolated classpaths.\n */")
public final class ClassLoader$ {
    public static final ClassLoader$ MODULE$ = new ClassLoader$();

    public <T> T withContextClassLoader(ClassLoader cl, Function0<T> t) {
        T t2;
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(cl);
            t2 = t.apply();
        }
        finally {
            thread.setContextClassLoader(oldCl);
        }
        return t2;
    }

    public boolean java9OrAbove() {
        return !System.getProperty("java.specification.version").startsWith("1.");
    }

    public URLClassLoader create(Seq<URL> urls, ClassLoader parent, ClassLoader sharedLoader, Seq<String> sharedPrefixes, Option<Logger> logger, Ctx.Home ctx) {
        return new URLClassLoader(urls, parent, sharedPrefixes, logger, sharedLoader){
            private final Seq sharedPrefixes$1;
            private final Option logger$1;
            private final ClassLoader sharedLoader$1;

            public Class<?> findClass(String name) {
                if (this.sharedPrefixes$1.exists((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(anon.1.$anonfun$findClass$1(name, x$1)))) {
                    this.logger$1.foreach((Function1<Logger, Object> & Serializable)x$1 -> {
                        anon.1.$anonfun$findClass$2(this, name, x$1);
                        return BoxedUnit.UNIT;
                    });
                    return this.sharedLoader$1.loadClass(name);
                }
                return super.findClass(name);
            }

            public static final /* synthetic */ boolean $anonfun$findClass$1(String name$1, String x$1) {
                return name$1.startsWith(x$1);
            }

            public static final /* synthetic */ void $anonfun$findClass$2(anon.1 $this, String name$1, Logger x$1) {
                x$1.debug(new StringBuilder(49).append("About to load class [").append(name$1).append("] from shared classloader [").append($this.sharedLoader$1).append("]").toString());
            }
            {
                this.sharedPrefixes$1 = sharedPrefixes$1;
                this.logger$1 = logger$1;
                this.sharedLoader$1 = sharedLoader$1;
                super((URL[])urls$1.toArray(ClassTag$.MODULE$.apply(URL.class)), ClassLoader$.MODULE$.mill$api$ClassLoader$$refinePlatformParent(parent$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$findClass$1$adapted(java.lang.String java.lang.String ), $anonfun$findClass$2$adapted(mill.api.ClassLoader$$anon$1 java.lang.String mill.api.Logger )}, serializedLambda);
            }
        };
    }

    public ClassLoader create$default$3() {
        return this.getClass().getClassLoader();
    }

    public Seq<String> create$default$4() {
        return Nil$.MODULE$;
    }

    public Option<Logger> create$default$5() {
        return None$.MODULE$;
    }

    @Scaladoc(value="/**\n   *  Return `ClassLoader.getPlatformClassLoader` for java 9 and above, if parent class loader is null,\n   *  otherwise return same parent class loader.\n   *  More details: https://docs.oracle.com/javase/9/migrate/toc.htm#JSMIG-GUID-A868D0B9-026F-4D46-B979-901834343F9E\n   *\n   *  `ClassLoader.getPlatformClassLoader` call is implemented via runtime reflection, cause otherwise\n   *  mill could be compiled only with jdk 9 or above. We don't want to introduce this restriction now.\n   */")
    public ClassLoader mill$api$ClassLoader$$refinePlatformParent(ClassLoader parent) {
        if (parent != null) {
            return parent;
        }
        if (this.java9OrAbove()) {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        Class<?> launcherClass = this.getClass().getClassLoader().loadClass("sun.misc.Launcher");
        Method getLauncherMethod = launcherClass.getMethod("getLauncher", new Class[0]);
        Object launcher = getLauncherMethod.invoke(null, new Object[0]);
        Method getClassLoaderMethod = launcher.getClass().getMethod("getClassLoader", new Class[0]);
        ClassLoader appClassLoader = (ClassLoader)getClassLoaderMethod.invoke(launcher, new Object[0]);
        return appClassLoader.getParent();
    }

    private ClassLoader$() {
    }
}

