/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Element;
import coursier.util.shaded.org.jsoup.nodes.Entities;
import coursier.util.shaded.org.jsoup.nodes.LeafNode;
import coursier.util.shaded.org.jsoup.nodes.Node;
import java.io.IOException;

public class TextNode
extends LeafNode {
    public TextNode(String text2) {
        super(text2);
    }

    @Override
    public String nodeName() {
        return "#text";
    }

    public String text() {
        return StringUtil.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String text2) {
        this.coreValue(text2);
        return this;
    }

    public String getWholeText() {
        return this.coreValue();
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.coreValue());
    }

    public TextNode splitText(int offset) {
        String text2 = this.coreValue();
        Validate.isTrue(offset >= 0, "Split offset must be not be negative");
        Validate.isTrue(offset < text2.length(), "Split offset must not be greater than current text length");
        String head = text2.substring(0, offset);
        String tail = text2.substring(offset);
        this.text(head);
        TextNode tailNode = new TextNode(tail);
        if (this.parentNode != null) {
            this.parentNode.addChildren(this.siblingIndex() + 1, tailNode);
        }
        return tailNode;
    }

    @Override
    void outerHtmlHead(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        boolean prettyPrint = out.prettyPrint();
        boolean normaliseWhite = prettyPrint && !Element.preserveWhitespace(this.parentNode);
        int escape = 1;
        if (normaliseWhite) {
            boolean couldSkip;
            boolean trimLikeBlock;
            escape |= 4;
            Element parent = this.parentNode instanceof Element ? (Element)this.parentNode : null;
            boolean bl = trimLikeBlock = parent != null && (parent.tag().isBlock() || parent.tag().formatAsBlock());
            if (trimLikeBlock && this.siblingIndex == 0 || this.parentNode instanceof Document) {
                escape |= 8;
            }
            if (trimLikeBlock && this.nextSibling() == null) {
                escape |= 0x10;
            }
            Node next = this.nextSibling();
            Node prev = this.previousSibling();
            boolean isBlank = this.isBlank();
            boolean bl2 = couldSkip = next instanceof Element && ((Element)next).shouldIndent(out) || next instanceof TextNode && ((TextNode)next).isBlank() || prev instanceof Element && (((Element)prev).isBlock() || prev.nameIs("br"));
            if (couldSkip && isBlank) {
                return;
            }
            if (prev == null && parent != null && parent.tag().formatAsBlock() && !isBlank || out.outline() && this.siblingNodes().size() > 0 && !isBlank || prev != null && prev.nameIs("br")) {
                this.indent(accum2, depth, out);
            }
        }
        Entities.escape(accum2, this.coreValue(), out, escape);
    }

    @Override
    void outerHtmlTail(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public TextNode clone() {
        return (TextNode)super.clone();
    }

    public static TextNode createFromEncoded(String encodedText) {
        String text2 = Entities.unescape(encodedText);
        return new TextNode(text2);
    }

    static String normaliseWhitespace(String text2) {
        text2 = StringUtil.normaliseWhitespace(text2);
        return text2;
    }

    static String stripLeadingWhitespace(String text2) {
        return text2.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder sb) {
        return sb.length() != 0 && sb.charAt(sb.length() - 1) == ' ';
    }
}

