/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestClassProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassExecutor;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionEventGenerator;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;

public class JUnitTestClassProcessor
extends AbstractJUnitTestClassProcessor {
    private final IdGenerator<?> idGenerator;
    private final JUnitSpec spec;
    private final Clock clock;

    public JUnitTestClassProcessor(JUnitSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super(actorFactory);
        this.spec = spec;
        this.idGenerator = idGenerator;
        this.clock = clock;
    }

    @Override
    protected TestResultProcessor createResultProcessorChain(TestResultProcessor resultProcessor) {
        AttachParentTestResultProcessor resultProcessorChain = new AttachParentTestResultProcessor(resultProcessor);
        return new TestClassExecutionEventGenerator((TestResultProcessor)resultProcessorChain, this.idGenerator, this.clock);
    }

    public void assertTestFrameworkAvailable() {
        try {
            Class.forName("org.junit.runner.notification.RunListener");
        }
        catch (ClassNotFoundException e) {
            throw new RequiresTestFrameworkTestClassProcessor.TestFrameworkNotAvailableException("Failed to load JUnit 4.  Please ensure that JUnit 4 is available on the test runtime classpath.");
        }
    }

    @Override
    protected Action<String> createTestExecutor(Actor resultProcessorActor) {
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)resultProcessorActor.getProxy(TestResultProcessor.class);
        TestClassExecutionListener threadSafeTestClassListener = (TestClassExecutionListener)resultProcessorActor.getProxy(TestClassExecutionListener.class);
        return new JUnitTestClassExecutor(Thread.currentThread().getContextClassLoader(), this.spec, this.clock, this.idGenerator, threadSafeTestClassListener, threadSafeResultProcessor);
    }
}

