/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.deps.IntSetSerializer;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class ClassAnalysis {
    private final String className;
    private final Set<String> privateClassDependencies;
    private final Set<String> accessibleClassDependencies;
    private final String dependencyToAllReason;
    private final IntSet constants;

    public ClassAnalysis(String className, Set<String> privateClassDependencies, Set<String> accessibleClassDependencies, String dependencyToAllReason, IntSet constants) {
        this.className = className;
        this.privateClassDependencies = ImmutableSet.copyOf(privateClassDependencies);
        this.accessibleClassDependencies = ImmutableSet.copyOf(accessibleClassDependencies);
        this.dependencyToAllReason = dependencyToAllReason;
        this.constants = constants.isEmpty() ? IntSets.EMPTY_SET : constants;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getPrivateClassDependencies() {
        return this.privateClassDependencies;
    }

    public Set<String> getAccessibleClassDependencies() {
        return this.accessibleClassDependencies;
    }

    public IntSet getConstants() {
        return this.constants;
    }

    public String getDependencyToAllReason() {
        return this.dependencyToAllReason;
    }

    public static class Serializer
    extends AbstractSerializer<ClassAnalysis> {
        private final StringInterner interner;
        private final SetSerializer<String> stringSetSerializer;

        public Serializer(StringInterner interner) {
            this.stringSetSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)new InterningStringSerializer((Interner)interner), false);
            this.interner = interner;
        }

        public ClassAnalysis read(Decoder decoder) throws Exception {
            String className = this.interner.intern(decoder.readString());
            String dependencyToAllReason = decoder.readNullableString();
            Set privateClasses = (Set)this.stringSetSerializer.read(decoder);
            Set accessibleClasses = (Set)this.stringSetSerializer.read(decoder);
            IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
            return new ClassAnalysis(className, privateClasses, accessibleClasses, dependencyToAllReason, constants);
        }

        public void write(Encoder encoder, ClassAnalysis value) throws Exception {
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeNullableString((CharSequence)value.getDependencyToAllReason());
            this.stringSetSerializer.write(encoder, value.getPrivateClassDependencies());
            this.stringSetSerializer.write(encoder, value.getAccessibleClassDependencies());
            IntSetSerializer.INSTANCE.write(encoder, value.getConstants());
        }
    }
}

