/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.evaluation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.internal.evaluation.EvaluationContext;
import org.gradle.internal.evaluation.EvaluationOwner;
import org.gradle.internal.evaluation.EvaluationScopeContext;

public class CircularEvaluationException
extends GradleException {
    private final ImmutableList<EvaluationOwner> evaluationCycle;

    CircularEvaluationException(List<EvaluationOwner> evaluationCycle) {
        this.evaluationCycle = ImmutableList.copyOf(evaluationCycle);
    }

    public String getMessage() {
        return "Circular evaluation detected: " + CircularEvaluationException.formatEvaluationChain(this.evaluationCycle);
    }

    public List<EvaluationOwner> getEvaluationCycle() {
        return this.evaluationCycle;
    }

    private static String formatEvaluationChain(List<EvaluationOwner> evaluationCycle) {
        try (EvaluationScopeContext ignored = EvaluationContext.current().nested();){
            String string = evaluationCycle.stream().map(CircularEvaluationException::safeToString).collect(Collectors.joining("\n -> "));
            return string;
        }
    }

    private static String safeToString(Object owner) {
        try {
            return owner.toString();
        }
        catch (Throwable e) {
            return owner.getClass().getName() + " (toString failed with " + e.getClass() + ")";
        }
    }
}

