/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationCreationRequest;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.JavaCompileExecutableUtils;
import org.gradle.api.internal.tasks.testing.TestExecutableUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.plugins.JvmToolchainsPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultJavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.internal.NaggingJavaPluginConvention;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.javadoc.internal.JavadocExecutableUtils;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Cast;
import org.gradle.internal.artifacts.configurations.AbstractRoleBasedConfigurationCreationRequest;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.language.jvm.tasks.ProcessResources;

public abstract class JavaBasePlugin
implements Plugin<Project> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    public static final String COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY = "org.gradle.java.compile-classpath-packaging";
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = JavaConfigurationVariantMapping.UNPUBLISHABLE_VARIANT_ARTIFACTS;
    private final boolean javaClasspathPackaging;
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public JavaBasePlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.javaClasspathPackaging = Boolean.getBoolean(COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY);
        this.jvmPluginServices = jvmPluginServices;
    }

    @Inject
    protected abstract JvmLanguageUtilities getJvmLanguageUtils();

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(JvmEcosystemPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getPluginManager().apply(JvmToolchainsPlugin.class);
        DefaultJavaPluginExtension javaPluginExtension = this.addExtensions(project);
        this.configureCompileDefaults(project, javaPluginExtension);
        this.configureSourceSetDefaults(project, javaPluginExtension);
        this.configureJavaDoc(project, javaPluginExtension);
        this.configureTest(project, javaPluginExtension);
        this.configureBuildNeeded(project);
        this.configureBuildDependents(project);
        this.configureArchiveDefaults(project);
    }

    private DefaultJavaPluginExtension addExtensions(Project project) {
        DefaultToolchainSpec toolchainSpec = (DefaultToolchainSpec)this.objectFactory.newInstance(DefaultToolchainSpec.class, new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByName("sourceSets");
        DefaultJavaPluginExtension javaPluginExtension = (DefaultJavaPluginExtension)project.getExtensions().create(JavaPluginExtension.class, "java", DefaultJavaPluginExtension.class, new Object[]{project, sourceSets, toolchainSpec});
        DeprecationLogger.whileDisabled(() -> project.getConvention().getPlugins().put("java", new NaggingJavaPluginConvention((DefaultJavaPluginConvention)this.objectFactory.newInstance(DefaultJavaPluginConvention.class, new Object[]{project, javaPluginExtension}))));
        return javaPluginExtension;
    }

    private void configureSourceSetDefaults(Project project, JavaPluginExtension javaPluginExtension) {
        javaPluginExtension.getSourceSets().all(sourceSet -> {
            ConfigurationContainer configurations = project.getConfigurations();
            this.defineConfigurationsForSourceSet((SourceSet)sourceSet, (RoleBasedConfigurationContainerInternal)configurations);
            this.definePathsForSourceSet((SourceSet)sourceSet, project);
            this.createProcessResourcesTask((SourceSet)sourceSet, sourceSet.getResources(), project);
            TaskProvider<JavaCompile> compileTask = this.createCompileJavaTask((SourceSet)sourceSet, sourceSet.getJava(), project);
            this.createClassesTask((SourceSet)sourceSet, project);
            this.configureLibraryElements(compileTask, (SourceSet)sourceSet, configurations, this.objectFactory);
            this.configureTargetPlatform(compileTask, (SourceSet)sourceSet, configurations);
        });
    }

    private void configureLibraryElements(TaskProvider<JavaCompile> compileJava, SourceSet sourceSet, ConfigurationContainer configurations, ObjectFactory objectFactory) {
        Provider libraryElements = compileJava.flatMap(x -> x.getModularity().getInferModulePath()).map(inferModulePath -> {
            if (this.javaClasspathPackaging) {
                return "jar";
            }
            List sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)((FileTreeInternal)sourceSet.getJava().getAsFileTree()));
            if (JavaModuleDetector.isModuleSource((boolean)inferModulePath, (Iterable)sourcesRoots)) {
                return "jar";
            }
            return "classes";
        }).map(value -> (LibraryElements)objectFactory.named(LibraryElements.class, value));
        Configuration compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        compileClasspath.getAttributes().attributeProvider(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, libraryElements);
    }

    private void configureTargetPlatform(TaskProvider<JavaCompile> compileTask, SourceSet sourceSet, ConfigurationContainer configurations) {
        this.getJvmLanguageUtils().useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
        this.getJvmLanguageUtils().useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
    }

    private TaskProvider<JavaCompile> createCompileJavaTask(SourceSet sourceSet, SourceDirectorySet javaSource, Project project) {
        TaskProvider compileTask = project.getTasks().register(sourceSet.getCompileJavaTaskName(), JavaCompile.class, javaCompile -> {
            ConventionMapping conventionMapping = javaCompile.getConventionMapping();
            conventionMapping.map("classpath", () -> ((SourceSet)sourceSet).getCompileClasspath());
            JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, javaSource, javaCompile.getOptions(), project);
            javaCompile.setDescription("Compiles " + javaSource + ".");
            javaCompile.setSource((FileTree)javaSource);
            Provider toolchainOverrideSpec = project.provider(() -> JavaCompileExecutableUtils.getExecutableOverrideToolchainSpec((JavaCompile)javaCompile, (ObjectFactory)this.objectFactory));
            javaCompile.getJavaCompiler().convention(this.getToolchainTool(project, JavaToolchainService::compilerFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
            String generatedHeadersDir = "generated/sources/headers/" + javaSource.getName() + "/" + sourceSet.getName();
            javaCompile.getOptions().getHeaderOutputDirectory().convention(project.getLayout().getBuildDirectory().dir(generatedHeadersDir));
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaCompile.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, javaSource, project, (TaskProvider<? extends AbstractCompile>)compileTask, (Provider<CompileOptions>)compileTask.map(JavaCompile::getOptions));
        return compileTask;
    }

    private void createProcessResourcesTask(SourceSet sourceSet, SourceDirectorySet resourceSet, Project target) {
        TaskProvider processResources = target.getTasks().register(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, resourcesTask -> {
            resourcesTask.setDescription("Processes " + resourceSet + ".");
            new DslObject((Object)resourcesTask.getRootSpec()).getConventionMapping().map("destinationDir", () -> sourceSet.getOutput().getResourcesDir());
            resourcesTask.from(new Object[]{resourceSet});
        });
        DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
        output.setResourcesContributor(processResources.map(Copy::getDestinationDir), processResources);
    }

    private void createClassesTask(SourceSet sourceSet, Project target) {
        sourceSet.compiledBy(new Object[]{target.getTasks().register(sourceSet.getClassesTaskName(), classesTask -> {
            classesTask.setGroup(BUILD_TASK_NAME);
            classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
            classesTask.dependsOn(new Object[]{sourceSet.getOutput().getDirs()});
            classesTask.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
            classesTask.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
        })});
    }

    private void definePathsForSourceSet(SourceSet sourceSet, Project project) {
        ConventionMapping outputConventionMapping = ((IConventionAware)sourceSet.getOutput()).getConventionMapping();
        outputConventionMapping.map("resourcesDir", () -> {
            String classesDirName = "resources/" + sourceSet.getName();
            return ((Directory)project.getLayout().getBuildDirectory().dir(classesDirName).get()).getAsFile();
        });
        sourceSet.getJava().srcDir((Object)("src/" + sourceSet.getName() + "/java"));
        sourceSet.getResources().srcDir((Object)("src/" + sourceSet.getName() + "/resources"));
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, RoleBasedConfigurationContainerInternal configurations) {
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String sourceSetName = sourceSet.toString();
        SourceSetConfigurationCreationRequest implementationRequest = new SourceSetConfigurationCreationRequest(sourceSet.getName(), implementationConfigurationName, ConfigurationRoles.DEPENDENCY_SCOPE);
        Configuration implementationConfiguration = configurations.maybeCreate((RoleBasedConfigurationCreationRequest)implementationRequest);
        implementationConfiguration.setVisible(false);
        implementationConfiguration.setDescription("Implementation only dependencies for " + sourceSetName + ".");
        SourceSetConfigurationCreationRequest compileOnlyRequest = new SourceSetConfigurationCreationRequest(sourceSet.getName(), compileOnlyConfigurationName, ConfigurationRoles.DEPENDENCY_SCOPE);
        Configuration compileOnlyConfiguration = configurations.maybeCreate((RoleBasedConfigurationCreationRequest)compileOnlyRequest);
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.setDescription("Compile only dependencies for " + sourceSetName + ".");
        SourceSetConfigurationCreationRequest compileClasspathRequest = new SourceSetConfigurationCreationRequest(sourceSet.getName(), compileClasspathConfigurationName, ConfigurationRoles.RESOLVABLE);
        Configuration compileClasspathConfiguration = configurations.maybeCreate((RoleBasedConfigurationCreationRequest)compileClasspathRequest);
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(new Configuration[]{compileOnlyConfiguration, implementationConfiguration});
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSetName + ".");
        this.jvmPluginServices.configureAsCompileClasspath((HasConfigurableAttributes)compileClasspathConfiguration);
        SourceSetConfigurationCreationRequest annotationProcessorRequest = new SourceSetConfigurationCreationRequest(sourceSet.getName(), annotationProcessorConfigurationName, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE);
        Configuration annotationProcessorConfiguration = configurations.maybeCreate((RoleBasedConfigurationCreationRequest)annotationProcessorRequest);
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSetName + ".");
        this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)annotationProcessorConfiguration);
        SourceSetConfigurationCreationRequest runtimeOnlyRequest = new SourceSetConfigurationCreationRequest(sourceSet.getName(), runtimeOnlyConfigurationName, ConfigurationRoles.DEPENDENCY_SCOPE);
        Configuration runtimeOnlyConfiguration = configurations.maybeCreate((RoleBasedConfigurationCreationRequest)runtimeOnlyRequest);
        runtimeOnlyConfiguration.setVisible(false);
        runtimeOnlyConfiguration.setDescription("Runtime only dependencies for " + sourceSetName + ".");
        SourceSetConfigurationCreationRequest runtimeClasspathRequest = new SourceSetConfigurationCreationRequest(sourceSet.getName(), runtimeClasspathConfigurationName, ConfigurationRoles.RESOLVABLE);
        Configuration runtimeClasspathConfiguration = configurations.maybeCreate((RoleBasedConfigurationCreationRequest)runtimeClasspathRequest);
        runtimeClasspathConfiguration.setVisible(false);
        runtimeClasspathConfiguration.setDescription("Runtime classpath of " + sourceSetName + ".");
        runtimeClasspathConfiguration.extendsFrom(new Configuration[]{runtimeOnlyConfiguration, implementationConfiguration});
        this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)runtimeClasspathConfiguration);
        sourceSet.setCompileClasspath((FileCollection)compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus((FileCollection)runtimeClasspathConfiguration));
        sourceSet.setAnnotationProcessorPath((FileCollection)annotationProcessorConfiguration);
    }

    private void configureCompileDefaults(Project project, DefaultJavaPluginExtension javaExtension) {
        project.getTasks().withType(AbstractCompile.class).configureEach(compile -> {
            JvmPluginsHelper.configureCompileDefaults(compile, javaExtension, (rawConvention, javaVersionSupplier) -> {
                if (compile instanceof JavaCompile) {
                    JavaCompile javaCompile = (JavaCompile)compile;
                    if (javaCompile.getOptions().getRelease().isPresent()) {
                        return JavaVersion.toVersion((Object)javaCompile.getOptions().getRelease().get());
                    }
                    if (rawConvention != null) {
                        return rawConvention;
                    }
                    return JavaVersion.toVersion((Object)((JavaCompiler)javaCompile.getJavaCompiler().get()).getMetadata().getLanguageVersion().toString());
                }
                return (JavaVersion)javaVersionSupplier.get();
            });
            compile.getDestinationDirectory().convention(project.getProviders().provider((Callable)new BackwardCompatibilityOutputDirectoryConvention((AbstractCompile)compile)));
        });
    }

    private void configureJavaDoc(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Javadoc.class).configureEach(javadoc -> {
            javadoc.getConventionMapping().map("destinationDir", () -> new File(((Directory)javaPluginExtension.getDocsDir().get()).getAsFile(), "javadoc"));
            javadoc.getConventionMapping().map("title", () -> ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle());
            Provider toolchainOverrideSpec = project.provider(() -> JavadocExecutableUtils.getExecutableOverrideToolchainSpec((Javadoc)javadoc, (ObjectFactory)this.objectFactory));
            javadoc.getJavadocTool().convention(this.getToolchainTool(project, JavaToolchainService::javadocToolFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
        });
    }

    private void configureBuildNeeded(Project project) {
        project.getTasks().register(BUILD_NEEDED_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
        });
    }

    private void configureBuildDependents(Project project) {
        project.getTasks().register(BUILD_DEPENDENTS_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
        });
    }

    private void configureArchiveDefaults(Project project) {
        BasePluginExtension basePluginExtension = (BasePluginExtension)project.getExtensions().getByType(BasePluginExtension.class);
        project.getTasks().withType(Jar.class).configureEach(task -> task.getDestinationDirectory().convention((Provider)basePluginExtension.getLibsDirectory()));
    }

    private void configureTest(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Test.class).configureEach(test -> this.configureTestDefaults((Test)test, project, javaPluginExtension));
    }

    private void configureTestDefaults(Test test, Project project, JavaPluginExtension javaPluginExtension) {
        DirectoryReport htmlReport = test.getReports().getHtml();
        JUnitXmlReport xmlReport = test.getReports().getJunitXml();
        xmlReport.getOutputLocation().convention(javaPluginExtension.getTestResultsDir().dir(test.getName()));
        htmlReport.getOutputLocation().convention(javaPluginExtension.getTestReportDir().dir(test.getName()));
        test.getBinaryResultsDirectory().convention(javaPluginExtension.getTestResultsDir().dir(test.getName() + "/binary"));
        test.workingDir((Object)project.getProjectDir());
        Provider toolchainOverrideSpec = project.provider(() -> TestExecutableUtils.getExecutableToolchainSpec((Test)test, (ObjectFactory)this.objectFactory));
        test.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper, Provider<JavaToolchainSpec> toolchainOverride) {
        JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return toolchainOverride.orElse((Object)extension.getToolchain()).flatMap(spec -> (Provider)toolMapper.apply(service, (JavaToolchainSpec)spec));
    }

    private static final class SourceSetConfigurationCreationRequest
    extends AbstractRoleBasedConfigurationCreationRequest {
        private final String sourceSetName;

        private SourceSetConfigurationCreationRequest(String sourceSetName, String configurationName, ConfigurationRole role) {
            super(configurationName, role);
            this.sourceSetName = sourceSetName;
        }

        public String getSourceSetName() {
            return this.sourceSetName;
        }

        public void warnAboutNeedToMutateUsage(DeprecatableConfiguration conf) {
            String msgDiscovery = this.getUsageDiscoveryMessage(conf);
            String msgExpectation = this.getUsageExpectationMessage();
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)(msgDiscovery + msgExpectation)).withAdvice(this.getUsageMutationAdvice()).willBecomeAnErrorInGradle9().withUserManual("building_java_projects", "sec:implicit_sourceset_configurations")).nagUser();
        }

        private String getUsageDiscoveryMessage(DeprecatableConfiguration conf) {
            String currentUsageDesc = UsageDescriber.describeCurrentUsage((DeprecatableConfiguration)conf);
            return String.format("When creating configurations during sourceSet %s setup, Gradle found that configuration %s already exists with permitted usage(s):\n%s\n", this.sourceSetName, this.getConfigurationName(), currentUsageDesc);
        }

        private String getUsageExpectationMessage() {
            String expectedUsageDesc = UsageDescriber.describeRole((ConfigurationRole)this.getRole());
            return String.format("Yet Gradle expected to create it with the usage(s):\n%s\nGradle will mutate the usage of configuration %s to match the expected usage. This may cause unexpected behavior. Creating configurations with reserved names", expectedUsageDesc, this.getConfigurationName());
        }

        public void failOnInabilityToMutateUsage() {
            ArrayList resolutions = Lists.newArrayList((Object[])new String[]{RoleBasedConfigurationCreationRequest.getDefaultReservedNameAdvice((String)this.getConfigurationName()), this.getUsageMutationAdvice()});
            throw new RoleBasedConfigurationCreationRequest.UnmodifiableUsageException(this.getConfigurationName(), (List)resolutions);
        }

        private String getUsageMutationAdvice() {
            return String.format("Create source set %s prior to creating or accessing the configurations associated with it.", this.sourceSetName);
        }
    }

    private static class BackwardCompatibilityOutputDirectoryConvention
    implements Callable<Directory> {
        private final AbstractCompile compile;
        private boolean recursiveCall;

        public BackwardCompatibilityOutputDirectoryConvention(AbstractCompile compile) {
            this.compile = compile;
        }

        @Override
        @Nullable
        public Directory call() throws Exception {
            File legacyValue;
            Method getter = GeneratedSubclasses.unpackType((Object)this.compile).getMethod("getDestinationDir", new Class[0]);
            if (getter.getDeclaringClass() == AbstractCompile.class) {
                return null;
            }
            if (this.recursiveCall) {
                return null;
            }
            this.recursiveCall = true;
            try {
                legacyValue = this.compile.getDestinationDir();
            }
            finally {
                this.recursiveCall = false;
            }
            if (legacyValue == null) {
                return null;
            }
            return this.compile.getProject().getLayout().getProjectDirectory().dir(legacyValue.getAbsolutePath());
        }
    }
}

