/**/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options


if language = '049' then do

  msg.1 = 'msg:Koma-Script'
  msg.2 = 'msg:Koma-Script: Entpacke Dateien'
  msg.3 = 'msg:Koma-Script: komascr.ins'
  msg.4 = 'msg:Koma-Script: amsclass.ins'
  msg.5 = 'msg:Koma-Script: amsldoc.tex sortiere Index amsldoc.idx'
  msg.6 = 'msg:Koma-Script: amsldoc.tex Lauf'
  msg.7 = 'von'

end
else do

  msg.1 = 'msg:Koma-Script'
  msg.2 = 'msg:Koma-Script: installing files'
  msg.3 = 'msg:Koma-Script: komascr.ins'
  msg.4 = 'msg:Koma-Script: amsclass.ins'
  msg.5 = 'msg:Koma-Script: amsldoc.tex sorting index amsldoc.idx'
  msg.6 = 'msg:Koma-Script: amsldoc.tex run'
  msg.7 = 'of'

end

install = texmf||'\os2tex\install'


target = texmf||'\tex\latex\koma-script'


if ""=directory(texmf||'\tex\latex') then do
  say "err:Verzeichniswechsel nicht mglich!"
  exit 1
end


if Pos("InstallFiles", options) > 0 then do

   say msg.1

   install||'\kdir '||texmf||'\tex\latex\koma-script'
   install||'\kdir '||texmf||'\doc\latex\koma-script'


   'md '||texmf||'\doc'
   'md '||texmf||'\doc\latex'
   'md '||texmf||'\doc\latex\koma-script'



   say msg.2

   install||'\unzip '||source||'\komascr.zip'



   tex = texmf||'\os2tex\bin\tex.exe'



   "copy "target"\*.tex "texmf"\doc\latex\koma-script"
   "del "target"\*.tex"
   "copy "target"\*.ps "texmf"\doc\latex\koma-script"
   "del "target"\*.ps"
   "copy "target"\*.dvi "texmf"\doc\latex\koma-script"
   "del "target"\*.dvi"
   "copy "target"\*.txt "texmf"\doc\latex\koma-script"
   "del "target"\*.txt"


   say msg.3

   tex||' -r -ff latex.fmt -pf '||texmf||'\os2tex\bin -pi '||texmf||'\tex; -po '||target||' komascr.ins'


end


if SysOS2Ver() = '2.30' then
  top = 48
else
  top = 45



/*
do i=1 to 3

  if i=3 then do
    say msg.5
    texmf||'\os2tex\bin\makeindex '||texmf||'\doc\ams\amslatex\amsldoc.idx'
  end

  say msg.6' 'i' 'msg.7' 3'
  tex||' -r -ff latex.fmt -pf '||texmf||'\os2tex\bin -pi '||texmf||'\tex;'||texmf||'\doc\ams -po '||texmf||'\doc\ams\amslatex -pt '||texmf||'\fonts\tfm amsldoc.tex'

end
*/




if Pos("CreateObjects", options) > 0 then do

   classname = 'WPProgram'

   if language = '049' then do
      objtitle  = 'koma script [M. Kohm]'
      objfile   = 'scrguide.dvi'
   end
   else do
      objtitle  = 'koma script [M. Kohm]'
      objfile   = 'screnggu.dvi'
   end

   location  = '<OS2TEX_MISC_FOLDER>'
   setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_koma_scrguide.dvi>;PARAMETERS='texmf'\doc\latex\koma-script\'objfile
   duplicate = 'replace'

   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end


end




if Pos("InstallFiles", options) > 0 then do

   "del "target"\*.ins"
   "del "target"\*.dtx"

end

