/*
 * Decompiled with CFR 0.152.
 */
package nts.math;

import nts.base.BoolPar;
import nts.base.Dimen;
import nts.base.Num;
import nts.builder.Builder;
import nts.builder.ParBuilder;
import nts.command.CommandBase;
import nts.math.DisplayBuilder;
import nts.math.FormulaGroup;
import nts.noad.Conversion;
import nts.node.BoxSizes;
import nts.node.ChrKernNode;
import nts.node.HBoxNode;
import nts.node.HorizIterator;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.SizesEvaluator;
import nts.node.VShiftNode;
import nts.typo.TypoCommand;

public class DisplayGroup
extends FormulaGroup {
    public static final int INTP_PRE_DISPLAY_PENALTY = CommandBase.newIntParam();
    public static final int INTP_POST_DISPLAY_PENALTY = CommandBase.newIntParam();
    public static final int DIMP_PRE_DISPLAY_SIZE = CommandBase.newDimParam();
    public static final int DIMP_DISPLAY_WIDTH = CommandBase.newDimParam();
    public static final int DIMP_DISPLAY_INDENT = CommandBase.newDimParam();
    public static final int GLUEP_ABOVE_DISPLAY_SKIP = CommandBase.newGlueParam();
    public static final int GLUEP_BELOW_DISPLAY_SKIP = CommandBase.newGlueParam();
    public static final int GLUEP_ABOVE_DISPLAY_SHORT_SKIP = CommandBase.newGlueParam();
    public static final int GLUEP_BELOW_DISPLAY_SHORT_SKIP = CommandBase.newGlueParam();
    private static final DisplayPacker packer = new DisplayPacker();

    public void stop() {
        int belowSkipParam;
        ChrKernNode kernBetween;
        Builder.pop();
        Builder bld = TypoCommand.getBld();
        CommandBase.Config cfg = CommandBase.getConfig();
        boolean success = FormulaGroup.necessaryParamsDefined();
        Node eqNoBox = ((DisplayBuilder)this.builder).getEqNoBox();
        boolean eqNoLeft = ((DisplayBuilder)this.builder).getEqNoLeft();
        if (eqNoBox == null) {
            eqNoLeft = false;
            FormulaGroup.expectAnotherMathShift();
        }
        NodeList list = NodeList.EMPTY;
        Dimen eqNoWidth = Dimen.ZERO;
        Dimen eqNoAdd = Dimen.ZERO;
        boolean sideBySide = false;
        if (success) {
            FormulaGroup.FormulaStyle style = new FormulaGroup.FormulaStyle(0, false);
            list = Conversion.madeOf(this.builder.getList().noads(), style);
            if (eqNoBox != null && !(eqNoWidth = eqNoBox.getWidth().plus(eqNoBox.getLeftX())).isZero()) {
                eqNoAdd = style.getDimPar(1).plus(eqNoWidth);
                sideBySide = true;
            }
        }
        NodeEnum mig = bld.wantsMigrations() ? list.extractedMigrations().nodes() : NodeList.EMPTY_ENUM;
        Dimen lastVis = cfg.getDimParam(DIMP_PRE_DISPLAY_SIZE);
        Dimen width = cfg.getDimParam(DIMP_DISPLAY_WIDTH);
        Dimen indent = cfg.getDimParam(DIMP_DISPLAY_INDENT);
        BoolPar parBroken = new BoolPar();
        HBoxNode box = packer.packHBox(list, eqNoAdd, width, parBroken);
        sideBySide = sideBySide && !parBroken.get();
        Dimen boxWidth = box.getWidth().plus(box.getLeftX());
        Dimen delta = width.minus(boxWidth).halved();
        if (sideBySide && delta.lessThan(eqNoWidth.times(2))) {
            delta = !list.isEmpty() && list.nodeAt(0).isSkip() ? Dimen.ZERO : width.minus(boxWidth).minus(eqNoWidth).halved();
        }
        bld.addPenalty(Num.valueOf(cfg.getIntParam(INTP_PRE_DISPLAY_PENALTY)));
        ChrKernNode chrKernNode = kernBetween = sideBySide ? new ChrKernNode(width.minus(boxWidth).minus(eqNoWidth).minus(delta)) : null;
        if (eqNoLeft) {
            belowSkipParam = GLUEP_BELOW_DISPLAY_SKIP;
            if (sideBySide) {
                int aboveSkipParam = GLUEP_ABOVE_DISPLAY_SKIP;
                bld.addSkip(cfg.getGlueParam(aboveSkipParam), cfg.getGlueName(aboveSkipParam));
                NodeList together = new NodeList(3);
                together.append(eqNoBox).append(kernBetween).append(box);
                box = HBoxNode.packedOf(together);
                DisplayGroup.appendBox(bld, box, indent);
            } else {
                DisplayGroup.appendBox(bld, eqNoBox, indent);
                bld.addPenalty(Num.valueOf(10000));
                DisplayGroup.appendBox(bld, box, indent.plus(delta));
            }
        } else {
            boolean biggerSkips = !delta.plus(indent).moreThan(lastVis);
            belowSkipParam = biggerSkips ? GLUEP_BELOW_DISPLAY_SKIP : GLUEP_BELOW_DISPLAY_SHORT_SKIP;
            int aboveSkipParam = biggerSkips ? GLUEP_ABOVE_DISPLAY_SKIP : GLUEP_ABOVE_DISPLAY_SHORT_SKIP;
            bld.addSkip(cfg.getGlueParam(aboveSkipParam), cfg.getGlueName(aboveSkipParam));
            if (sideBySide) {
                NodeList together = new NodeList(3);
                together.append(box).append(kernBetween).append(eqNoBox);
                box = HBoxNode.packedOf(together);
                DisplayGroup.appendBox(bld, box, indent.plus(delta));
            } else {
                DisplayGroup.appendBox(bld, box, indent.plus(delta));
                if (eqNoBox != null) {
                    bld.addPenalty(Num.valueOf(10000));
                    DisplayGroup.appendBox(bld, eqNoBox, indent.plus(width).minus(eqNoWidth));
                    belowSkipParam = -1;
                }
            }
        }
        bld.addNodes(mig);
        bld.addPenalty(Num.valueOf(cfg.getIntParam(INTP_POST_DISPLAY_PENALTY)));
        if (belowSkipParam != -1) {
            bld.addSkip(cfg.getGlueParam(belowSkipParam), cfg.getGlueName(belowSkipParam));
        }
    }

    private static void appendBox(Builder bld, Node node, Dimen shift) {
        TypoCommand.appendBox(bld, VShiftNode.shiftingRight(node, shift.plus(node.getLeftX())), false);
    }

    public void close() {
        DisplayGroup.resumeAfterDisplay();
    }

    public static void resumeAfterDisplay() {
        Builder bld = Builder.top();
        bld.setPrevGraf(bld.getPrevGraf() + 3);
        ParBuilder par = new ParBuilder(CommandBase.currLineNumber(), TypoCommand.getTypoConfig().getLanguage());
        Builder.push(par);
        CommandBase.skipOptExpSpacer();
        bld.buildPage();
    }

    public DisplayGroup(DisplayBuilder builder) {
        super(builder);
    }

    public DisplayGroup() {
        super(new DisplayBuilder(CommandBase.currLineNumber()));
    }

    public static class DisplayPacker
    extends TypoCommand.HBoxPacker {
        public HBoxNode packHBox(NodeList list, Dimen additional, Dimen desired, BoolPar broken) {
            BoolPar.set(broken, false);
            SizesEvaluator pack = new SizesEvaluator();
            HorizIterator.summarize(list.nodes(), pack);
            Dimen height = pack.getWidth();
            Dimen width = pack.getBody().plus(pack.getDepth());
            Dimen depth = pack.getLeftX();
            Dimen leftX = pack.getHeight();
            desired = desired.minus(leftX);
            Dimen attempt = width.min(desired.minus(additional));
            pack.evaluate(attempt.minus(width), list.isEmpty());
            if (pack.getReport() == 3 && !additional.isZero()) {
                BoolPar.set(broken, true);
                attempt = width.min(desired);
                pack.evaluate(attempt.minus(width), list.isEmpty());
            }
            BoxSizes sizes = new BoxSizes(height, attempt, depth, leftX);
            HBoxNode hbox = new HBoxNode(sizes, pack.getSetting(), list);
            if (pack.getReport() == 3) {
                this.addOverfullRule(list, pack.getOverfull());
            }
            if (this.check(pack)) {
                this.reportBox(hbox);
            }
            return hbox;
        }
    }
}

