/*
 * Decompiled with CFR 0.152.
 */
package nts.base;

import nts.base.BinFraction;

public final class Dimen
extends BinFraction {
    private static final int POINT_SHIFT = 16;
    private static final int MAX_REPR_VALUE = 0x3FFFFFFF;
    public static final double MAX_DOUBLE_VALUE = 20000.0;
    public static final Dimen NULL;
    public static final Dimen ZERO;
    public static final Dimen UNITY;
    public static final Dimen MAX_VALUE;
    public static final Dimen MAX_FROM_DOUBLE;
    public static final int REPR_UNITY = 65536;
    public static final Par NULL_PAR;
    public static final int UNI_BAD = 100;
    public static final int INF_BAD = 10000;
    public static final int DEPLORABLE = 100000;
    public static final int OVERFULL_BAD = 1000000;
    public static final int AWFUL_BAD = 0x3FFFFFFF;

    protected final int pointShift() {
        return 16;
    }

    public static void set(Par par, Dimen val) {
        if (par != null) {
            par.value = val;
        }
    }

    private static int makeRepr(int num) {
        return num << 16;
    }

    private static int makeRepr(int num, int den) {
        return (int)(((long)num << 16) / (long)den);
    }

    private static int makeRepr(BinFraction x) {
        return BinFraction.makeRepr(x, 16);
    }

    private static int makeRepr(double d) {
        if ((d *= 65536.0) >= 1.073741823E9) {
            return 0x3FFFFFFF;
        }
        if (d <= -1.073741823E9) {
            return -1073741823;
        }
        return Dimen.round(d);
    }

    private static int round(double d) {
        return (int)(d >= 0.0 ? d + 0.5 : d - 0.5);
    }

    public static Dimen valueOf(Dimen d) {
        return new Dimen(d.value);
    }

    public static Dimen valueOf(int num) {
        return new Dimen(Dimen.makeRepr(num));
    }

    public static Dimen valueOf(int num, int den) {
        return new Dimen(Dimen.makeRepr(num, den));
    }

    public static Dimen valueOf(BinFraction x) {
        return new Dimen(Dimen.makeRepr(x));
    }

    public static Dimen valueOf(double d) {
        return new Dimen(Dimen.makeRepr(d));
    }

    public static Dimen shiftedValueOf(int num, int offs) {
        return new Dimen((offs += 16) < 0 ? num >> -offs : num << offs);
    }

    public static Dimen valueOf(String s) throws NumberFormatException {
        boolean negative;
        int pointIndex = s.indexOf(46);
        if (pointIndex < 0) {
            return new Dimen(Dimen.makeRepr(Integer.parseInt(s)));
        }
        long val = Integer.parseInt(s.substring(0, pointIndex));
        int SHIFT = 17;
        int frac = 0;
        int i = pointIndex + 17 + 1;
        if (i > s.length()) {
            i = s.length();
        }
        while (--i > pointIndex) {
            int digit = Character.digit(s.charAt(i), 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            frac = (frac + (digit << 17)) / 10;
        }
        boolean bl = negative = val < 0L;
        if (negative) {
            val = -val;
        }
        val <<= 16;
        if ((val |= (long)(frac + 1 >>> 1)) > 0x3FFFFFFFL) {
            throw new NumberFormatException(s);
        }
        return new Dimen(negative ? (int)(-val) : (int)val);
    }

    public int sign() {
        return this.value > 0 ? 1 : (this.value < 0 ? -1 : 0);
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public boolean equals(Dimen d) {
        return this.value == d.value;
    }

    public boolean equals(int num) {
        return this.value == Dimen.makeRepr(num);
    }

    public boolean equals(int num, int den) {
        return this.value == Dimen.makeRepr(num, den);
    }

    public boolean equals(BinFraction x) {
        return this.value == Dimen.makeRepr(x);
    }

    public boolean equals(double d) {
        return this.value == Dimen.makeRepr(d);
    }

    public boolean lessThan(Dimen d) {
        return this.value < d.value;
    }

    public boolean lessThan(int num) {
        return this.value < Dimen.makeRepr(num);
    }

    public boolean lessThan(int num, int den) {
        return this.value < Dimen.makeRepr(num, den);
    }

    public boolean lessThan(BinFraction x) {
        return this.value < Dimen.makeRepr(x);
    }

    public boolean lessThan(double d) {
        return this.value < Dimen.makeRepr(d);
    }

    public boolean moreThan(Dimen d) {
        return this.value > d.value;
    }

    public boolean moreThan(int num) {
        return this.value > Dimen.makeRepr(num);
    }

    public boolean moreThan(int num, int den) {
        return this.value > Dimen.makeRepr(num, den);
    }

    public boolean moreThan(BinFraction x) {
        return this.value > Dimen.makeRepr(x);
    }

    public boolean moreThan(double d) {
        return this.value > Dimen.makeRepr(d);
    }

    public Dimen negative() {
        return new Dimen(-this.value);
    }

    public Dimen absolute() {
        return this.value < 0 ? new Dimen(-this.value) : this;
    }

    public Dimen plus(Dimen d) {
        return new Dimen(this.value + d.value);
    }

    public Dimen plus(int num) {
        return new Dimen(this.value + Dimen.makeRepr(num));
    }

    public Dimen plus(int num, int den) {
        return new Dimen(this.value + Dimen.makeRepr(num, den));
    }

    public Dimen plus(BinFraction x) {
        return new Dimen(this.value + Dimen.makeRepr(x));
    }

    public Dimen plus(double d) {
        return new Dimen(this.value + Dimen.makeRepr(d));
    }

    public Dimen minus(Dimen d) {
        return new Dimen(this.value - d.value);
    }

    public Dimen minus(int num) {
        return new Dimen(this.value - Dimen.makeRepr(num));
    }

    public Dimen minus(int num, int den) {
        return new Dimen(this.value - Dimen.makeRepr(num, den));
    }

    public Dimen minus(BinFraction x) {
        return new Dimen(this.value - Dimen.makeRepr(x));
    }

    public Dimen minus(double d) {
        return new Dimen(this.value - Dimen.makeRepr(d));
    }

    public Dimen times(Dimen d) {
        return new Dimen((int)((long)this.value * (long)d.value >> 16));
    }

    public Dimen times(int num) {
        return new Dimen(this.value * num);
    }

    public Dimen times(int num, int den) {
        return new Dimen((int)((long)this.value * (long)num / (long)den));
    }

    public Dimen times(BinFraction x) {
        return new Dimen(this.reprTimes(x));
    }

    public Dimen times(double d) {
        return new Dimen(Dimen.round((double)this.value * d));
    }

    public Dimen limitedTimes(double d) {
        double limit = 1.0E9;
        double v = (double)this.value * d;
        if (v > 1.0E9) {
            v = 1.0E9;
        } else if (v < -1.0E9) {
            v = -1.0E9;
        }
        return new Dimen(Dimen.round(v));
    }

    public Dimen over(Dimen d) {
        return new Dimen((int)(((long)this.value << 16) / (long)d.value));
    }

    public Dimen over(int num) {
        return new Dimen(this.value / num);
    }

    public Dimen over(int num, int den) {
        return new Dimen((int)((long)this.value * (long)den / (long)num));
    }

    public Dimen over(BinFraction x) {
        return new Dimen(this.reprOver(x));
    }

    public Dimen over(double d) {
        return new Dimen(Dimen.round((double)this.value / d));
    }

    public double doubleOver(Dimen d) {
        return (double)this.value / (double)d.value;
    }

    public Dimen roundDivide(int num) {
        return new Dimen((int)((2L * (long)this.value + (long)num) / (2L * (long)num)));
    }

    public int divide(Dimen d) {
        return this.value / d.value;
    }

    public Dimen modulo(Dimen d) {
        return new Dimen(this.value % d.value);
    }

    public Dimen shifted(int offs) {
        return new Dimen(offs < 0 ? this.value >> -offs : this.value << offs);
    }

    public Dimen min(Dimen d) {
        return this.moreThan(d) ? d : this;
    }

    public Dimen max(Dimen d) {
        return this.lessThan(d) ? d : this;
    }

    public Dimen halved() {
        return new Dimen((this.value + 1 & 0xFFFFFFFE) / 2);
    }

    public int toInt() {
        return this.value >> 16;
    }

    public int toInt(int den) {
        return (int)((long)this.value * (long)den >> 16);
    }

    public double toDouble() {
        return (double)this.value / 65536.0;
    }

    public String toString(String unit) {
        return this.toString() + unit;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int v = this.value;
        int MASK = 65535;
        if (v < 0) {
            buf.append('-');
            v = -v;
        }
        buf.append(v >>> 16);
        buf.append('.');
        v = 10 * (v & 0xFFFF) + 5;
        int delta = 10;
        do {
            if (delta > 65536) {
                v += 32768 - delta / 2;
            }
            buf.append(Character.forDigit(v >>> 16, 10));
        } while ((v = 10 * (v & 0xFFFF)) > (delta *= 10));
        return buf.toString();
    }

    public int hashCode() {
        return 6128 * this.value;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Dimen && ((Dimen)o).value == this.value;
    }

    /*
     * WARNING - void declaration
     */
    public int badness(Dimen limit) {
        void ratio;
        int n;
        int total = this.value;
        int sum = limit.value;
        if (total == 0) {
            return 0;
        }
        if (total < 0) {
            total = -total;
            sum = -sum;
        }
        if (sum <= 0) {
            return 10000;
        }
        if (total <= 7230584) {
            n = total * 297 / sum;
        } else if (sum >= 1663497) {
            n = total / (sum / 297);
        } else {
            return 10000;
        }
        return ratio > 1290 ? 10000 : (ratio * ratio * ratio + 131072) / 262144;
    }

    public String toSp() {
        return Integer.toString(this.value);
    }

    private Dimen(int val) {
        super(val);
    }

    static {
        ZERO = Dimen.valueOf(0);
        UNITY = Dimen.valueOf(1);
        MAX_VALUE = new Dimen(0x3FFFFFFF);
        MAX_FROM_DOUBLE = Dimen.valueOf(20000.0);
    }

    public static class Par {
        private Dimen value;

        public void set(Dimen val) {
            this.value = val;
        }

        public Dimen get() {
            return this.value;
        }

        static /* synthetic */ Dimen access$0(Par par) {
            return par.value;
        }

        public Par() {
            this.value = null;
        }

        public Par(Dimen val) {
            this.value = val;
        }
    }

    public static interface Provider {
        public Dimen getDimenValue();
    }
}

