## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions --- an extension package for Alpha
 # 
 #  FILE: "latexMathbb.tcl"
 #                                    created: 26/1/98 {3:12:38 pm} 
 #                                last update: 26/4/98 {10:54:16 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1998  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

# extension declaration
alpha::feature latexMathbb 1.01 {TeX Bib} {
    newPref variable blackboardBoldSymbols "QZRN" TeX TeX::adjustMathbb
    hook::register mode::init TeX::adjustMathbb TeX
} "" "" maintainer {
    {Vince Darley} <darley@fas.harvard.edu> <http://www.fas.harvard.edu/~darley/>
} help {
    Turns 'ZZ' into $\mathbb{Z}$ on the fly, and the same for any
    other symbols in your blackboardBoldSymbols preference.
} uninstall this-file

proc TeX::adjustMathbb {args} {
    global TeXmodeVars
    foreach symb [split $TeXmodeVars(blackboardBoldSymbols) ""] {
	Bind '[string tolower $symb]' <s> [list TeX::checkMathbb $symb] TeX
    }
}

proc TeX::checkMathbb {symb} {
    if {[lookAt [pos::math [getPos] - 1]] != $symb} { typeText $symb ; return }
    select [pos::math [getPos] - 1] [getPos]
    doUppercaseMathStyle mathbb "math blackboard bold"
}

